% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhoneHMD.r
\name{opiPresent_for_PhoneHMD}
\alias{opiPresent_for_PhoneHMD}
\title{Implementation of opiPresent for the PhoneHMD machine.}
\arguments{
\item{stim}{A list containing:
\itemize{
\item \code{lum} List of stimuli luminances (cd/m^2).
\item \code{stim.length} The number of elements in this stimuli.
\item \code{color1} List of stimulus colors for FLAT shapes and patterns.
\item \code{sx} List of diameters along major axis of ellipse (degrees).
\item \code{sy} List of diameters along minor axis of ellipse (degrees).
\item \code{eye} The eye for which to apply the settings.
\item \code{t} List of stimuli presentation times (ms). If 0, then the next stim
list element will be shown simultaneously.
\item \code{w} Time to wait for response including presentation time (ms).
\item \code{x} List of x co-ordinates of stimuli (degrees).
\item \code{y} List of y co-ordinates of stimuli (degrees).
\item \code{envSdx} (Optional) List of envelope sd in x direction in degrees.
Only useful if envType != NONE
\item \code{envSdy} (Optional) List of envelope sd in y direction in degrees.
Only useful if envType != NONE
\item \code{envRotation} (Optional) List of envelope rotations in degrees. Only useful if envType != NONE
\item \code{type} (Optional) Stimulus type. Values include FLAT, SINE,
CHECKERBOARD, SQUARESINE, G1, G2, G3, IMAGE
\item \code{frequency} (Optional) List of frequencies (in cycles per degrees)
for generation of spatial patterns. Only useful if type != FLAT
\item \code{color2} (Optional) List of second colors for non-FLAT shapes
\item \code{fullFoV} (Optional) If !0 fullFoV scales image to full field of view
and sx/sy are ignored.
\item \code{phase} (Optional) List of phases (in degrees) for generation of
spatial patterns. Only useful if type != FLAT
\item \code{imageFilename} (Optional) If type == IMAGE, the filename on the
local filesystem of the machine running JOVP of the image to use
\item \code{shape} (Optional) Stimulus shape. Values include CROSS, TRIANGLE,
CIRCLE, SQUARE, OPTOTYPE.
\item \code{rotation} (Optional) List of angles of rotation of stimuli
(degrees). Only useful if sx != sy specified.
\item \code{texRotation} (Optional) List of angles of rotation of stimuli
(degrees). Only useful if type != FLAT
\item \code{defocus} (Optional) List of defocus values in Diopters for stimulus post-processing.
\item \code{envType} (Optional) List of envelope types to apply to the stims).
Only useful if type != FLAT
\item \code{contrast} (Optional) List of stimulus contrasts (from 0 to 1). Only
useful if type != FLAT.
\item \code{optotype} (Optional) If shape == OPTOTYPE, the letter A to Z to use
}}

\item{...}{Parameters for other opiPresent implementations that are ignored here.}
}
\value{
A list containing:
\itemize{
\item \code{err} \code{NULL} if there was no error, a string message if there is an error.
\item \code{time} Response time from stimulus onset if button pressed (ms).
\item \code{seen} '1' if seen, '0' if not.
}
}
\description{
This is for internal use only. Use \code{\link[=opiPresent]{opiPresent()}} after
\code{chooseOPI("PhoneHMD")} to call this function.
}
\details{
Elements in \code{lum} can take on values in the range \code{[0.0, 1.0E10]}.

\code{stim.length} can take on values in the range \code{[1, 2147483647]}.

Elements in \code{color1} can take on values in the range \code{[0.0, 1.0]}.

Elements in \code{sx} can take on values in the range \code{[0.0, 180.0]}.

Elements in \code{sy} can take on values in the range \code{[0.0, 180.0]}.

Elements in \code{eye} can take on values in the set
\code{{"left", "right", "both", "none"}}.

Elements in \code{t} can take on values in the range \code{[0.0, 1.0E10]}.

\code{w} can take on values in the range \code{[0.0, 1.0E10]}.

Elements in \code{x} can take on values in the range \code{[-90.0, 90.0]}.

Elements in \code{y} can take on values in the range \code{[-90.0, 90.0]}.

Elements in \code{envSdx} can take on values in the range
\code{[-1.0E10, 1.0E10]}.

Elements in \code{envSdy} can take on values in the range
\code{[-1.0E10, 1.0E10]}.

Elements in \code{envRotation} can take on values in
the range \code{[-1.0E10, 1.0E10]}.

Elements in \code{type} can take on values in the set
\code{{"flat", "checkerboard", "sine", "squaresine", "g1",
                 "g2", "g3", "text", "image"}}.

Elements in \code{frequency} can take on values in the
range \code{[0.0, 300.0]}.

Elements in \code{color2} can take on values in the range \code{[0.0, 1.0]}.

Elements in \code{fullFoV} can take on values in the
range \code{[-1.0E10, 1.0E10]}.

Elements in \code{phase} can take on values in the range \code{[0.0, 1.0E10]}.

Elements in \code{shape} can take on values in the set
\code{{"triangle", "square", "polygon", "hollow_triangle",
                  "hollow_square", "hollow_polygon", "cross", "maltese",
                  "circle", "annulus", "optotype", "text", "model"}}.

Elements in \code{rotation} can take on values in the range \code{[0.0, 360.0]}.

Elements in \code{texRotation} can take on values in
the range \code{[0.0, 360.0]}.

Elements in \code{defocus} can take on values in the range \code{[0.0, 1.0E10]}.

Elements in \code{envType} can take on values in the set
\code{{"none", "square", "circle", "gaussian"}}.

Elements in \code{contrast} can take on values in the range \code{[0.0, 1.0]}.

Elements in \code{optotype} can take on values in the
set \code{{"a", "b", "c", "d", "e", "f", "g", "h", "i",
                     "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t",
                     "u", "v", "w", "x", "y", "z"}}.
}
\examples{
\dontrun{
chooseOpi("PhoneHMD")
opiInitialise(list(port = 50001, ip = "localhost"))
opiSetup(list(eye = "BOTH"))
result <- opiPresent(stim = list(lum = list(300.0), stim.length = 1, color1 = list(list(1.0,
                  1.0, 1.0)), sx = list(1.72), sy = list(1.72),
                  eye = list("LEFT"), t = list(200.0), w = 1500.0, x = list(0.0), y = list(0.0)))
}

}
\seealso{
\code{\link[=opiPresent]{opiPresent()}}
}
