% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.samp.R
\name{sim.samp}
\alias{sim.samp}
\title{Code for Generating Random Samples}
\usage{
sim.samp(nrep, n, DIST, ...)
}
\arguments{
\item{nrep}{= number of random data sets}

\item{n}{= sample size of each data set}

\item{DIST}{= distribution to generate from, e.g., runif, rnorm, additional parameters in ...}

\item{...}{Additional arguments to be passed}
}
\value{
N by n matrix, each row is a data set of size n
}
\description{
\code{sim.samp} --- generates N samples of size n from distribution DIST
}
\examples{
N<-100
 set.seed(346)            # sets the random number seed
 sim.samp(N,15,rnorm)->z  # 100 N(0,1) samples of size n=15
 sim.samp(N,40,rnorm,mean=10,sd=5)->z  # 100 N(10,25) samples of size n=40

# Function Code

sim.samp <- function(nrep,n,DIST,...){
 data <- matrix(DIST(n * nrep, ...), ncol = n, nrow = nrep)}

}
\author{
Dennis Boos, Kevin Matthew, Jason Osborne
}
