% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-Coo.R
\name{stack}
\alias{stack}
\alias{stack.Coo}
\alias{stack.Ldk}
\title{Family picture of shapes}
\usage{
\method{stack}{Coo}(
  x,
  cols,
  borders,
  fac,
  palette = col_summer,
  coo_sample = 120,
  points = FALSE,
  first.point = TRUE,
  centroid = TRUE,
  ldk = TRUE,
  ldk_pch = 3,
  ldk_col = "#FF000055",
  ldk_cex = 0.5,
  ldk_links = FALSE,
  ldk_confell = FALSE,
  ldk_contour = FALSE,
  ldk_chull = FALSE,
  ldk_labels = FALSE,
  xy.axis = TRUE,
  title = substitute(x),
  ...
)

\method{stack}{Ldk}(
  x,
  cols,
  borders,
  first.point = TRUE,
  centroid = TRUE,
  ldk = TRUE,
  ldk_pch = 20,
  ldk_col = col_alpha("#000000", 0.5),
  ldk_cex = 0.3,
  meanshape = FALSE,
  meanshape_col = "#FF0000",
  ldk_links = FALSE,
  ldk_confell = FALSE,
  ldk_contour = FALSE,
  ldk_chull = FALSE,
  ldk_labels = FALSE,
  slidings = TRUE,
  slidings_pch = "",
  xy.axis = TRUE,
  title = substitute(x),
  ...
)
}
\arguments{
\item{x}{The \code{Coo} object to plot.}

\item{cols}{A \code{vector} of colors for drawing the outlines.
Either a single value or of length exactly equals to the number of coordinates.}

\item{borders}{A \code{vector} of colors for drawing the borders.
Either a single value or of length exactly equals to the number of coordinates.}

\item{fac}{a factor within the $fac slot for colors}

\item{palette}{a color palette to use when fac is provided}

\item{coo_sample}{if not NULL the number of point per shape to display (to plot quickly)}

\item{points}{\code{logical} whether to draw or not points}

\item{first.point}{\code{logical} whether to draw or not the first point}

\item{centroid}{\code{logical} whether to draw or not the centroid}

\item{ldk}{\code{logical}. Whether to display landmarks (if any).}

\item{ldk_pch}{\code{pch} for these landmarks}

\item{ldk_col}{color for these landmarks}

\item{ldk_cex}{\code{cex} for these landmarks}

\item{ldk_links}{\code{logical} whether to draw links (of the mean shape)}

\item{ldk_confell}{\code{logical} whether to draw conf ellipses}

\item{ldk_contour}{\code{logical} whether to draw contour lines}

\item{ldk_chull}{\code{logical} whether to draw convex hull}

\item{ldk_labels}{\code{logical} whether to draw landmark labels}

\item{xy.axis}{whether to draw or not the x and y axes}

\item{title}{a title for the plot. The name of the \code{Coo} by default}

\item{...}{further arguments to be passed to \link{coo_plot}}

\item{meanshape}{\code{logical} whether to add meanshape related stuff (below)}

\item{meanshape_col}{a color for everything meanshape}

\item{slidings}{\code{logical} whether to draw slidings semi landmarks}

\item{slidings_pch}{\code{pch} for semi landmarks}
}
\value{
a plot
}
\description{
Plots all the outlines, on the same graph, from a \link{Coo} (\link{Out}, \link{Opn} or \link{Ldk})
object.
}
\examples{
\donttest{
stack(bot)
bot.f <- efourier(bot, 12)
stack(bot.f)
stack(mosquito, borders='#1A1A1A22', first.point=FALSE)
stack(hearts)
stack(hearts, ldk=FALSE)
stack(hearts, borders='#1A1A1A22', ldk=TRUE, ldk_col=col_summer(4), ldk_pch=20)
stack(hearts, fac="aut", palette=col_sari)

chaffal <- fgProcrustes(chaff)
stack(chaffal, slidings=FALSE)
stack(chaffal, meanshape=TRUE, meanshape_col="blue")
}
}
\seealso{
Other Coo_graphics: 
\code{\link{inspect}()},
\code{\link{panel}()}
}
\concept{Coo_graphics}
