% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-calibrate.R
\name{calibrate_deviations}
\alias{calibrate_deviations}
\alias{calibrate_deviations_efourier}
\alias{calibrate_deviations_tfourier}
\alias{calibrate_deviations_rfourier}
\alias{calibrate_deviations_sfourier}
\alias{calibrate_deviations_npoly}
\alias{calibrate_deviations_opoly}
\alias{calibrate_deviations_dfourier}
\title{Quantitative calibration, through deviations, for Out and Opn objects}
\usage{
calibrate_deviations()

calibrate_deviations_efourier(
  x,
  id = 1,
  range,
  norm.centsize = TRUE,
  dist.method = edm_nearest,
  interpolate.factor = 1,
  dist.nbpts = 120,
  plot = TRUE
)

calibrate_deviations_tfourier(
  x,
  id = 1,
  range,
  norm.centsize = TRUE,
  dist.method = edm_nearest,
  interpolate.factor = 1,
  dist.nbpts = 120,
  plot = TRUE
)

calibrate_deviations_rfourier(
  x,
  id = 1,
  range,
  norm.centsize = TRUE,
  dist.method = edm_nearest,
  interpolate.factor = 1,
  dist.nbpts = 120,
  plot = TRUE
)

calibrate_deviations_sfourier(
  x,
  id = 1,
  range,
  norm.centsize = TRUE,
  dist.method = edm_nearest,
  interpolate.factor = 1,
  dist.nbpts = 120,
  plot = TRUE
)

calibrate_deviations_npoly(
  x,
  id = 1,
  range,
  norm.centsize = TRUE,
  dist.method = edm_nearest,
  interpolate.factor = 1,
  dist.nbpts = 120,
  plot = TRUE
)

calibrate_deviations_opoly(
  x,
  id = 1,
  range,
  norm.centsize = TRUE,
  dist.method = edm_nearest,
  interpolate.factor = 1,
  dist.nbpts = 120,
  plot = TRUE
)

calibrate_deviations_dfourier(
  x,
  id = 1,
  range,
  norm.centsize = TRUE,
  dist.method = edm_nearest,
  interpolate.factor = 1,
  dist.nbpts = 120,
  plot = TRUE
)
}
\arguments{
\item{x}{and \code{Out} or \code{Opn} object on which to calibrate_deviations}

\item{id}{the shape on which to perform calibrate_deviations}

\item{range}{vector of harmonics (or degree for opoly and npoly on Opn) on which to perform calibrate_deviations.
If not provided, the harmonics corresponding to 0.9, 0.95 and 0.99\% of harmonic power
are used.}

\item{norm.centsize}{logical whether to normalize deviation by the centroid size}

\item{dist.method}{a method such as \link{edm_nearest} to calculate deviations}

\item{interpolate.factor}{a numeric to increase the number of points on the original shape (1 by default)}

\item{dist.nbpts}{numeric the number of points to use for deviations calculations}

\item{plot}{logical whether to print the graph (FALSE is you just want the calculations)}
}
\value{
a ggplot object and the full list of intermediate results. See examples.
}
\description{
Calculate deviations from original and reconstructed shapes using a
range of harmonic number.
}
\details{
Note that from version 1.1, the calculation changed and fixed a problem. Before,
the 'best' possible shape was calculated using the highest possible number of harmonics.
This worked well for efourier but not for others (eg rfourier, tfourier) as they
are known to be unstable with high number of harmonics. From now on, Momocs uses
the 'real' shape, as it is (so it must be centered) and uses \link{coo_interpolate}
to produce \code{interpolate.factor} times more coordinates as the shape
has and using the default \code{dist.method}, eg \link{edm_nearest},
the latter finds the euclidean distance, for each point on the reconstructed shape,
the closest point on this interpolated shape. \code{interpolate.factor} being set
to 1 by default, no interpolation will be made in you do not ask for it. Note,
that interpolation to decrease artefactual errors may also be done outside
\code{calibrate_deviations} and will be probably be removed from it
in further versions.

Note also that this code is quite old now and would need a good review,
planned for 2018.

For *poly methods on Opn objects, the deviations are calculated from a degree 12 polynom.
}
\examples{
b5 <- slice(bot, 1:5) #for the sake of speed
b5 \%>\% calibrate_deviations_efourier()
b5 \%>\% calibrate_deviations_rfourier()
b5 \%>\% calibrate_deviations_tfourier()
b5 \%>\% calibrate_deviations_sfourier()

o5 <- slice(olea, 1:5) #for the sake of speed
o5 \%>\% calibrate_deviations_opoly()
o5 \%>\% calibrate_deviations_npoly()
o5 \%>\% calibrate_deviations_dfourier()

}
\seealso{
Other calibration: 
\code{\link{calibrate_harmonicpower}()},
\code{\link{calibrate_r2}()},
\code{\link{calibrate_reconstructions}}
}
\concept{calibration}
