% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult-KMEDOIDS.R
\name{KMEDOIDS}
\alias{KMEDOIDS}
\alias{KMEDOIDS.default}
\alias{KMEDOIDS.Coe}
\alias{KMEDOIDS.PCA}
\title{KMEDOIDS}
\usage{
KMEDOIDS(x, k, metric = "euclidean", ...)

\method{KMEDOIDS}{default}(x, k, metric = "euclidean", ...)

\method{KMEDOIDS}{Coe}(x, k, metric = "euclidean", ...)

\method{KMEDOIDS}{PCA}(x, k, metric = "euclidean", retain, ...)
}
\arguments{
\item{x}{a \link{Coe} or \link{PCA} object}

\item{k}{numeric number of centers}

\item{metric}{one of \code{euclidean} (default) or \code{manhattan}, to feed \link[cluster:pam]{cluster::pam}}

\item{...}{additional arguments to feed \link[cluster:pam]{cluster::pam}}

\item{retain}{when passing a \link{PCA} how many PCs to retain, or a proportion of total variance, see \link{LDA}}
}
\value{
see \link[cluster:pam]{cluster::pam}. Other components are returned (\code{fac}, etc.)
}
\description{
A basic implementation of kmedoids on top of \link[cluster:pam]{cluster::pam}
Beware that morphospaces are calculated so far for the 1st and 2nd
component.
}
\examples{
data(bot)
bp <- PCA(efourier(bot, 10))
KMEANS(bp, 2)

set.seed(123) # for reproducibility on a dummy matrix
matrix(rnorm(100, 10, 10)) \%>\%
KMEDOIDS(5)

# On a Coe
bot_f <- bot \%>\% efourier()

bot_k <- bot_f \%>\% KMEDOIDS(2)
# confusion matrix
table(bot_k$fac$type, bot_k$clustering)

# on a PCA
bot_k2 <- bot_f \%>\% PCA() \%>\% KMEDOIDS(12, retain=0.9)

# confusion matrix
with(bot_k, table(fac$type, clustering))
# silhouette plot
bot_k \%>\% plot_silhouette()

# average width as a function of k
k_range <- 2:12
widths <- sapply(k_range, function(k) KMEDOIDS(bot_f, k=k)$silinfo$avg.width)
plot(k_range, widths, type="b")
}
\seealso{
Other multivariate: 
\code{\link{CLUST}()},
\code{\link{KMEANS}()},
\code{\link{LDA}()},
\code{\link{MANOVA_PW}()},
\code{\link{MANOVA}()},
\code{\link{MDS}()},
\code{\link{MSHAPES}()},
\code{\link{NMDS}()},
\code{\link{PCA}()},
\code{\link{classification_metrics}()}
}
\concept{multivariate}
