% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_effective_reproduction_number}
\alias{plot_effective_reproduction_number}
\title{Plot effective reproduction number (Re) over time}
\usage{
plot_effective_reproduction_number(
  GT,
  S,
  inc,
  dates,
  est_r0_ml,
  RT,
  output_file = "RN_avec_dates_EM-ML.pdf"
)
}
\arguments{
\item{GT}{Numeric vector. Generation time distribution.}

\item{S}{Numeric vector. Secondary cases.}

\item{inc}{Numeric vector. Incidence time series.}

\item{dates}{Date vector corresponding to observations.}

\item{est_r0_ml}{Function to estimate R0.}

\item{RT}{Function to compute Rt.}

\item{output_file}{Output PDF filename.}
}
\value{
NULL (plot is saved as PDF)
}
\description{
Computes and visualizes the effective reproduction number (Rt) over time
using incidence data and generation time distribution. Optionally overlays
a smoothed spline curve.
}
