% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Lasoelascox.R
\name{Lasoelacox}
\alias{Lasoelacox}
\title{Wapper function for glmnet}
\usage{
Lasoelacox(
  Survival,
  Censor,
  Mdata,
  Prognostic,
  Quantile = 0.5,
  Metlist = NULL,
  Plots = FALSE,
  Standardize = TRUE,
  Alpha = 1,
  Fold = 4,
  nlambda = 100
)
}
\arguments{
\item{Survival}{A vector of survival time with length equals to number of subjects}

\item{Censor}{A vector of censoring indicator}

\item{Mdata}{A large or small metabolic profile matrix. A matrix with metabolic profiles where the number of rows should be equal to the number of metabolites and number of columns should be equal to number of patients.}

\item{Prognostic}{A dataframe containing possible prognostic(s) factor and/or treatment effect to be used in the model.}

\item{Quantile}{The cut off value for the classifier, default is the median cutoff}

\item{Metlist}{A list of metabolites to be considered in the model usually smaller than the metabolites in the Mdata . Default is to use all metabolites available}

\item{Plots}{A boolean parameter indicating if plots should be shown. Default is FALSE. If TRUE, the first plot is the partial likelihood deviance against the logarithmn of each lambda while the second is the coefficients versus the lamdas}

\item{Standardize}{A Logical flag for the standardization of the metabolite matrix, prior to fitting the model sequence. The coefficients are always returned on the original scale. Default is standardize=TRUE.}

\item{Alpha}{The mixing parameter for glmnet (see \code{\link[glmnet]{glmnet}}). The range is 0<= Alpha <= 1. The Default is 1}

\item{Fold}{number of folds to be used for the cross validation. Its value ranges between 3 and the numbe rof subjects in the dataset}

\item{nlambda}{The number of lambda values - default is 100 as in \link[glmnet]{glmnet}.}
}
\value{
A object is returned with the following values
\item{Coefficients.NonZero}{The coefficients of the selected metabolites}
\item{Selected.Mets}{The selected metabolites}
\item{n}{The number of selected metabolites}
\item{Risk.scores}{The risk scores of the subjects}
\item{Risk.group}{The risk classification of the subjects based on the specified quantile}
\item{SurvFit}{The cox analysis of the riskgroup based on the selected metabolites and the prognostic factors}
\item{Select}{A Boolean argument indicating if there was selection or not}
}
\description{
The function uses the glmnet function to firstly do the variable selection either with Lasso, Elastic net or ridge regressions before the survial analysis. The survival analysis is based on the selected metabolites in the presence or absence of prognostic factors.
}
\details{
This is a wrapper function for glmnet and it fits models using either Lasso, Elastic net and Ridge regressions. This is done in the presence or absence of prognostic factors. The prognostic factor when avaialable will always be forced to be in the model so no penalty for it. Optimum lambda will be used to select the non-zero shrinkage coefficients, the nonzero selected metabolites will thus be used in the survival analysis and in calculation of the risk scores.
}
\examples{
## FIRSTLY SIMULATING A METABOLIC SURVIVAL DATA
Data = MSData(nPatients = 100, nMet = 150, Prop = 0.5)

## USING THE FUNCTION
Results = Lasoelacox(Survival=Data$Survival, Censor=Data$Censor,
Mdata=t(Data$Mdata), Prognostic = Data$Prognostic, Quantile = 0.5,
Metlist = NULL, Plots = FALSE, Standardize = TRUE, Alpha = 1)

## VIEW THE SELECTED METABOLITES
Results$Selected.mets
## NUMBER OF SELECTED METABOLITES
Results$n

## VIEW THE CLASSIFICATION GROUP OF EACH SUBJECT
Results$Risk.Group

## VIEW THE SURVIVAL ANALYSIS RESULT
Results$SurvFit

## TO CHECK IF THERE WAS ANY SELECTION
Results$Select
}
\seealso{
\code{\link[survival]{coxph}},
\code{\link[MetabolicSurv]{EstimateHR}}, \code{\link[glmnet]{glmnet}},
}
\author{
Olajumoke Evangelina Owokotomo, \email{olajumoke.owokotomo@uhasselt.be}

Ziv Shkedy
}
