% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTE.R
\name{MTE}
\alias{MTE}
\title{Maximum Tangent-likelihood Estimation}
\usage{
MTE(y, X, beta.ini, t, p, intercept = FALSE)
}
\arguments{
\item{y}{the response vector}

\item{X}{design matrix}

\item{beta.ini}{initial value of estimates, could be from OLS.}

\item{t}{the tangent point. You may specify a sequence of values, so that the function automatically select the optimal one.}

\item{p}{Taylor expansion order, up to 3.}

\item{intercept}{logical input that indicates if intercept needs to be estimated. Default is FALSE.}
}
\value{
Returns estimates from MTE method.
\item{beta}{the regression coefficient estimates}
\item{fitted.value}{predicted response}
\item{t}{the optimal tangent point through data-driven method}
}
\description{
It estimates linear regression coefficient using MTE.
The function produces robust estimates of linear regression. Outliers and contamination would be downweighted.
It is robust to Gaussian assumption of the error term. Initial estimates need to be provided.
}
\examples{
set.seed(2017)
n=200; d=4
X=matrix(rnorm(n*d), nrow=n, ncol=d)
beta=c(1, -1, 2, -2)
y=-2+X\%*\%beta+c(rnorm(150), rnorm(30,10,10), rnorm(20,0,100))
beta0=beta.ls=lm(y~X)$coeff
beta.MTE=MTE(y,X,beta0,0.1,2, intercept=TRUE)$beta
cbind(c(-2,beta), beta.ls, beta.MTE)

}
