% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doStat.R
\name{doStat}
\alias{doStat}
\title{Performing statistics}
\usage{
doStat(x, Group = NULL)
}
\arguments{
\item{x}{sample ion intensity matrix, row sample, column feature.}

\item{Group}{sample group information}
}
\value{
a dataframe with statistical information
}
\description{
performing statistics, including calculating fold change, p-values and VIP values
}
\examples{
dat <- matrix(runif(2*300), ncol = 2, nrow = 300)
rownames(dat) <- 1:dim(dat)[1]
myGroup <- rep_len(LETTERS[1:3], 300)
ret <- doStat(dat, Group = myGroup)
}
