% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZIGPMM.R
\name{ZIGPMM}
\alias{ZIGPMM}
\title{MM algorithm based on the AD method for type I multivariate zero-inflated generalized poisson distribution}
\usage{
ZIGPMM(data, phi0, la, th, Maxiter = 2000, convergence = 1e-06, ...)
}
\arguments{
\item{data}{Data.frame or Matrix that contains corresponding covariates.}

\item{phi0}{Probability value for the zero-inflated parameter for ZIGP model.}

\item{la}{The scale parameter for Generalized Poisson distribution model.}

\item{th}{The discrete parameter for Generalized Poisson distribution model.}

\item{Maxiter}{The maximum number of iterations is specified by default as 2000.}

\item{convergence}{Specify the convergence criterion, the default is 1e-6.}

\item{...}{Additional arguments}
}
\value{
An object of class \code{ZIGPMM} that contains the following fields: total amount of observations,
the number of iterations, convergence rate, the log likelihood value, estimated results for the unknown parameters,
the standard deviation of estimate for the unknown parameters, the likelihood-based 95\% confidence interval for the unknown parameters,
information criterion: AIC value and BIC value.
}
\description{
Let \eqn{Z \sim Bernoulli(1- \phi)},
\eqn{{x} = (X_1,\cdots, X_m)^T}, \eqn{X_i \sim GP(\lambda_i, \theta_i)}, for \eqn{i = 1,\cdots,m} , and \eqn{(Z,X_1,\cdots, X_m)}
are mutually independent. An \eqn{m} dimensional discrete random vector \eqn{{y}=(Y_1,\cdots, Y_m)^T} is said to have a Type I
multivariate zero-inflated generalized Poisson distribution(ZIGP) distribution if

\deqn{ {y} \overset{\rm{d}}= Z{x}= \left\{ \begin{array}{ll}
{0} & \text{with probability} \ \lambda \\ {x} & \text{with probability} \ 1-\lambda \\ \end{array} \right. }

where \eqn{\lambda \in [0,1)}, \eqn{{\lambda}=(\lambda_1,\cdots, \lambda_m)^T }, \eqn{{\theta}=(\theta_1,\cdots, \theta_m)^T },
\eqn{max(-1, -\lambda_i/q_i) < \theta_i \leqslant 1} and \eqn{q_i \geqslant 4} is the largest positive integer for each \eqn{\lambda_i + \theta_{i}q_{i}>0} when \eqn{\theta_{i}<0}.
The \code{ZIGPMM} function is used to calculate the Type I multivariate ZIGP model.
}
\details{
The \code{ZIGPMM} function is used to calculate Type I multivariate zero-inflated generalized Poisson distribution model using MM algorithms
based on AD technology. \code{data} is provided by user by default, it can be a data frame or a matrix. In addition, the unknown parameters require users to give appropriate initial values,
where \code{0<=phi0<1}, each \code{th} should satisfy \code{0<=th<1}, and each \code{la} should be greater than 0.
}
\examples{
x1 <- c(0, 0, 0,38, 0,19,25, 0,25, 0)
x2 <- c(0, 0, 0,23, 0,51,24, 0,10, 0)
y <- cbind(x1, x2)
phi0 = 0.5; la = rep(1,2); th = rep(0.1,2)
ZIGPMM(y, phi0, la, th)

}
\references{
Tian G.L., Huang X.F. and Xu, J.(2019). 'An assembly and decomposition approach for constructing separable minorizing functions in a class of MM algorithms.' \emph{Statistica Sinica} \strong{29}(2), 961-982.

Huang X.F., Tian G.L., Zhang, C. and Jiang, X.(2017). 'Type I multivariate zero-inflated generalized Poisson distribution with applications.' \emph{Statistics and its Interface} \strong{10}(2), 291-311.
}
