bell.mle <- function(x, a, b, k, lambda, distr = "BB12", method = "B") {
  if ( distr == "BB12" ) {
    res <- BGFD::mBellB(x, a = a, b = b, k = k, lambda = lambda, method = method)
    param <- res$Estimates[, 1]
    names(param) <- c("alpha", "beta", "kappa", "lambda")
  } else if ( distr == "BBX" ) {
    res <- BGFD::mBellBX(x, a = a, lambda = lambda, method = method)
	  param <- res$Estimates[, 1]
    names(param) <- c("alpha",  "lambda")
  } else if ( distr == "BE" ) {
    res <- BGFD::mBellE(x, alpha = a,lambda = lambda, method = method)
	  param <- res$Estimates[, 1]
    names(param) <- c("alpha",  "lambda")
  } else if ( distr == "BEW" ) {
    res <- BGFD::mBellEW(x, alpha = a, beta = b, theta = k, lambda = lambda, method = method)
	  param <- res$Estimates[, 1]
    names(param) <- c("alpha", "beta", "theta", "lambda")
  } else if ( distr == "BEE" ) {
    res <- BGFD::mBellEE(x, alpha = a, beta = b, lambda = lambda, method = method)
	  param <- res$Estimates[, 1]
    names(param) <- c("alpha", "beta", "lambda")
  } else if ( distr == "BF" ) {
    res <- BGFD::mBellF(x, a = a, b = b, lambda = lambda, method = method)
	  param <- res$Estimates[, 1]
    names(param) <- c("alpha", "beta", "lambda")
  } else if ( distr == "BL" ) {
    res <- BGFD::mBellL(x, b=a, q=b, lambda = lambda, method = method)
	  param <- res$Estimates[, 1]
    names(param) <- c("beta", "q", "lambda")
  } else if ( distr == "BW" ) {
    res <- BGFD::mBellW(x, alpha = a, beta = b, lambda = lambda, method = method)
	  param <- res$Estimates[, 1]
    names(param) <- c("alpha", "beta", "lambda")
  } else if ( distr == "CBB12" ) {
    res <- BGFD::mCBellB(x, a = a, b = b, k=k, lambda = lambda, method = method)
	  param <- res$Estimates[, 1]
    names(param) <- c("alpha", "beta", "kappa", "lambda")
  } else if ( distr == "CBBX" ) {
    res <- BGFD::mCBellBX(x, a = a, lambda = lambda, method = method)
	  param <- res$Estimates[, 1]
    names(param) <- c("alpha",  "lambda")
  } else if ( distr == "CBE" ) {
    res <- BGFD::mCBellE(x, alpha = a, lambda = lambda, method = method)
	  param <- res$Estimates[, 1]
    names(param) <- c("alpha",  "lambda")
  } else if ( distr == "CBEW" ) {
    res <- BGFD::mCBellEW(x, alpha = a, beta = b, theta = k, lambda = lambda, method = method)
	  param <- res$Estimates[, 1]
    names(param) <- c("alpha", "beta", "theta", "lambda")
   } else if ( distr == "CBEE" ) {
    res <- BGFD::mCBellEE(x, alpha = a, beta = b, lambda = lambda, method = method)
	  param <- res$Estimates[, 1]
    names(param) <- c("alpha", "beta", "lambda")
  } else if ( distr == "CBF" ) {
    res <- BGFD::mCBellF(x, a = a, b = b, lambda = lambda, method = method)
	  param <- res$Estimates[, 1]
    names(param) <- c("alpha", "beta", "lambda")
  } else if ( distr == "CBL" ) {
    res <- BGFD::mCBellL(x, b=a, q=b, lambda = lambda, method = method)
	  param <- res$Estimates[, 1]
    names(param) <- c("beta", "q", "lambda")
  } else if ( distr == "CBW" ) {
    res <- BGFD::mCBellW(x, alpha = a, beta = b, lambda = lambda, method = method)
	  param <- res$Estimates[, 1]
    names(param) <- c("alpha", "beta", "lambda")
  }
  list( param = param, loglik = -0.5 * res[[ 2 ]][5] )
}



