% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIIVsem-data.R
\docType{data}
\name{bollen1989c}
\alias{bollen1989c}
\title{Subjective class data}
\format{
A data frame with 432 rows and 5 variables
}
\usage{
bollen1989c
}
\description{
The following data is from Bollen (1989) using data from
Kluegel et al. (1977). These data include  measures of actual 
income (inc) and occupational prestige (occ),  measures 
of respondents' subjective assessments of income (subinc), 
occupational prestige (subocc), and overall SES status (subgen).
}
\details{
\itemize{
  \item occ. actual occupational prestige
  \item inc. actual income
  \item subocc. respondents' subjective assessments of prestige
  \item subinc. respondents' subjective assessments of income
  \item subgen. respondents' subjective assessments of SES status
}
}
\examples{

\dontrun{
 model <-    '
	subinc  ~ inc + subocc
   subocc  ~ occ + subinc
   subgen  ~ subinc + subocc
	subinc ~~ subocc + subgen
   subocc ~~ subgen
	inc    ~~ occ
 '
}

}
\references{
Bollen, K. A. 1989. Structural Equations with Latent Variables. 
New York: Wiley
  
Kluegel, J. R., Singleton, R., & Starnes, C. E. (1977). 
Subjective Class Identification: A Multiple Indicator 
Approach. American Sociological Review, 42(4), 599–611.
}
\keyword{datasets}
