% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PN-epiSIS-network-P.R
\name{spn_P_epiSIS_network}
\alias{spn_P_epiSIS_network}
\title{Make Places (P) For a Network (SEI Mosquitoes - SIS Humans)}
\usage{
spn_P_epiSIS_network(node_list, params, cube)
}
\arguments{
\item{node_list}{a character vector specifying what type of nodes to create;
(m = a node_id with only mosquitoes, h = a node_id with only humans, b = a node_id with both humans and mosquitoes)}

\item{params}{a named list of parameters (see details)}

\item{cube}{an inheritance cube from the \code{MGDrivE} package (e.g. \code{\link[MGDrivE]{cubeMendelian}})}
}
\value{
a list with two elements: \code{ix} contains labeled indices of the
places by life stage and node_id, \code{u} is the character vector of places (P)
}
\description{
This function makes the set of places (P) for a SPN model of a metapopulation
network for simulation of coupled SEI-SIS dynamics. It is the network version
of \code{\link{spn_P_epiSIS_node}}.
}
\details{
The \code{params} argument supplies all of the ecological parameters necessary
to calculate equilibrium values. This function requires the \code{nE},
\code{nL}, \code{nP}, and \code{nEIP} parameters to be specified. For more details, see
\code{\link{equilibrium_SEI_SIS}}

For examples of using this function, see:
\code{vignette("epi-network", package = "MGDrivE2")}
}
