% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LocKer.R
\name{LocKer}
\alias{LocKer}
\title{Locally sparse estimator of generalized varying coefficient model for asynchronous longitudinal data.}
\usage{
LocKer(
  X,
  Y,
  family,
  X_obser_num,
  Y_obser_num,
  X_obser,
  Y_obser,
  timeint,
  L_list,
  roupen_para_list,
  lambda_list,
  absTol_list,
  nfold = 5,
  d = 3
)
}
\arguments{
\item{X}{A \code{list} of \emph{n} vectors, where \emph{n} is the sample size. Each entry contains the measurements of the covariate for each subject at the observation time correspond to \code{X_obser}.}

\item{Y}{A \code{list} of \emph{n} vectors, where \emph{n} is the sample size. Each entry contains the measurements of the response for each subject at the observation time correspond to \code{Y_obser}.}

\item{family}{A \code{character} string representing the distribution family of the response. The value can be "Gaussian", "binomial", "poisson".}

\item{X_obser_num}{A \code{vector} denoting the observation size of the covariate for each subject.}

\item{Y_obser_num}{A \code{vector} denoting the observation size of the response for each subject.}

\item{X_obser}{A \code{list} of \emph{n} vectors, where \emph{n} is the sample size. Each entry contains the observation times of the covariate for each subject.}

\item{Y_obser}{A \code{list} of \emph{n} vectors, where \emph{n} is the sample size. Each entry contains the observation times of the response for each subject.}

\item{timeint}{A \code{vector} of length two denoting the supporting interval.}

\item{L_list}{A \code{vector} denoting the candidates for the number of B-spline basis functions. The best \code{L} is chosen by cross-validation.}

\item{roupen_para_list}{A \code{vector} denoting the candidates for the roughness parameters. The best roughness parameter is chosen by \code{EBIC} together with sparseness parameter.}

\item{lambda_list}{A \code{vector} denoting the candidates for the sparseness parameter. The best sparseness parameter is chosen by \code{EBIC} together with roughness parameter.}

\item{absTol_list}{A \code{vector} denoting the threshold of the norm for coefficient function on each sub-interval. The \code{vector} is related to \code{L_list}, with the same length as \code{L_list}.}

\item{nfold}{An \code{integer} denoting the number of fold for the selection of \code{L} by cross-validation. (default: 5)}

\item{d}{An \code{integer} denoting the degree of B-spline basis functions. (default: 3)}
}
\value{
A \code{list} containing the following components:
\item{beta0fd_est}{A functional data object denoting the estimated intercept function.}
\item{betafd_est}{A functional data object denoting the estimated coefficient function.}
\item{time}{A \code{scalar} denoting the computation time.}
\item{L}{An \code{integer} denoting the selected number of B-spline basis function.}
\item{roupen_select}{A \code{scalar} denoting the selected roughness parameter.}
\item{lambda_select}{A \code{scalar} denoting the selected sparseness parameter.}
\item{EBIC}{A \code{matrix} denoting the \code{EBIC} scores for various roughness parameters and sparseness parameters belongs to the candidates when using the selected \code{L}.}
}
\description{
Locally sparse estimator of generalized varying coefficient model for asynchronous longitudinal data by kernel-weighted estimating equation. The function is suitable for generalized varying coefficient model with one covariate.
}
\examples{
####Generate data
n <- 200
beta0 <- function(x){cos(2 * pi * x)}
beta <- function(x){sin(2 * pi * x)}
Y_rate <- 15
X_rate <- 15
Y_obser_num <- NULL
X_obser_num <- NULL
Y_obser <- list()
X_obser <- list()
for(i in 1:n){
Y_obser_num[i] <- stats::rpois(1, Y_rate) + 1
Y_obser[[i]] <- stats::runif(Y_obser_num[i], 0, 1)
X_obser_num[i] <- stats::rpois(1, X_rate) + 1
X_obser[[i]] <- stats::runif(X_obser_num[i], 0, 1)
}
## The covariate functions Xi(t)
X_basis <- fda::create.bspline.basis(c(0, 1), nbasis = 74, norder = 5,
breaks = seq(0, 1, length.out = 71))
a <- matrix(0, nrow = n, ncol = 74)
X <- list()
XY <- list() #X at the observation time of Y
muY <- list()
for(i in 1:n){
a[i,] <- stats::rnorm(74)
Xi_B <- splines::bs(X_obser[[i]], knots = seq(0, 1, length.out = 71)[-c(1, 71)],
degree = 4, intercept = TRUE)
X[[i]] <- Xi_B \%*\% a[i,]
Yi_B <- splines::bs(Y_obser[[i]], knots = seq(0, 1, length.out = 71)[-c(1, 71)],
degree = 4, intercept = TRUE)
XY[[i]] <- Yi_B \%*\% a[i,]
muY[[i]] <- beta0(Y_obser[[i]]) + XY[[i]] * beta(Y_obser[[i]])
}
Y <- list()
errY <- list()
for(i in 1:n){
errY[[i]] <- stats::rnorm(Y_obser_num[[i]], mean = 0, sd = 1)
Y[[i]] <- muY[[i]] + errY[[i]]
}
L_list <- 20
absTol_list <- 10^(-3)
roupen_para_list <- 1.5 * 10^(-3)
lambda_list <- c(0, 0.001, 0.002)
LocKer_list <- LocKer(X, Y, family = "Gaussian", X_obser_num, Y_obser_num, X_obser,
Y_obser, timeint = c(0, 1), L_list, roupen_para_list, lambda_list, absTol_list)
}
