% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaudermanModelling.R
\name{modelGoudermanLongitudinal}
\alias{modelGoudermanLongitudinal}
\title{Fitting the Gouderman LME Model with using Gouderman-Data Arrangement.}
\usage{
modelGoudermanLongitudinal(mygaudermanLDO, correctionMethod = "bonferroni")
}
\arguments{
\item{mygaudermanLDO}{GaudermanLDO data object, created by the generalized 'Gauderman' algorithm (GGA).}

\item{correctionMethod}{correction for p-values. Possible methods: 'holm', 'hochberg', 'hommel', 'bonferroni', 'BH', 'BY', 'fdr', 'none'}
}
\value{
'GaudermanModelEvaluation' Results of the evaluation of the Fitted linear mixed effect models for the defined time periods.
}
\description{
Uses the linear mixed effects modeling to build the final 'Gauderman' model. The 'Gauderman' modification enables the exact calculation of the significance of a specified section of the spline model.
}
\examples{
  
  data(LoBraExample)
  selectedLDO <- selectComponents(ldo, components)
  gaudermanLDOexample <- createGoudermanData(selectedLDO, breaks=c(8, 12), center=12, timeperiod=2)
  evalResult<- modelGoudermanLongitudinal(gaudermanLDOexample)
  message(evalResult@correctedpvalues<0.005)
  
}
