% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportion.CI.R
\name{proportion.CI}
\alias{proportion.CI}
\title{Large Sample Confidence Interval for a Population Proportion}
\usage{
proportion.CI(x, n, conf.level)
}
\arguments{
\item{x}{a single numeric value corresponding with either the proportion estimate or the number of successes of the sample.}

\item{n}{a single positive integer corresponding with the sample size.}

\item{conf.level}{a single numeric value corresponding with the confidence level of the interval; must be a value in (0,1).}
}
\value{
A list containing the following components:
\item{estimate}{numeric value corresponding with the sample proportion estimate.}
\item{CI}{a numeric vector of length two containing the lower and upper bounds of the confidence interval.}
Independently on the user saving those values, the function provides a summary of the result on the console.
}
\description{
\code{proportion.CI} provides a pointwise estimation and a confidence interval for a population proportion.
}
\details{
Counts of successes and failures must be nonnegative and hence not greater than the corresponding numbers of trials which must be positive. All finite counts should be integers.

If the number of successes are given, then the proportion estimate is computed.
}
\examples{
#Given the sample proportion estimate
proportion.CI(0.3, 100, conf.level=0.95)

#Given the number of successes
proportion.CI(30,100,conf.level=0.95)

}
