% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma.R
\name{plotGamma}
\alias{plotGamma}
\title{Density Function, Distribution Function and/or
Quantile Function Representations associated with a Gamma Distribution}
\usage{
plotGamma(lambda, shape, type = "b", col = "black")
}
\arguments{
\item{lambda, shape}{parameters of the Gamma distribution (mean equal to \code{shape}/\code{lambda}).}

\item{type}{a character string giving the type of desired plot. The following values are possible:
"b" (default) for density function, distribution function and quantile function representations together,
"dis" for distribution function representation,
"den" for density function representation and "q" for quantile function representation.}

\item{col}{a single colour associated with the different representations; default to "black".}
}
\value{
This function is called for the side effect of drawing the plot.
}
\description{
\code{plotGamma} represents density, distribution and/or quantile functions associated with a Gamma
 distribution with certain parameters \code{lambda} and  \code{shape}.
}
\examples{
lambda=0.5;shape=4
plotGamma(lambda,shape)
plotGamma(lambda,shape,col="red")
plotGamma(lambda,shape,type="q")
plotGamma(lambda,shape,type="dis")
plotGamma(lambda,shape,type="den")
}
