% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LST_terra.R
\name{SWA}
\alias{SWA}
\title{Split-window algorithm}
\usage{
SWA(
  TIR_10 = TIR_10,
  TIR_11 = TIR_11,
  tau_10 = tau_10,
  tau_11 = tau_11,
  E_10 = E_10,
  E_11 = E_11
)
}
\arguments{
\item{TIR_10}{SpatRaster object, Landsat band 10}

\item{TIR_11}{SpatRaster object, Landsat band 11}

\item{tau_10}{Atmospheric transmittance for Landsat band 10}

\item{tau_11}{Atmospheric transmittance for Landsat band 11}

\item{E_10}{SpatRaster object, Land Surface Emissivity for Landsat band 10 calculated according to Skokovic et al. 2014 or Yu et al. 2014}

\item{E_11}{SpatRaster object, Land Surface Emissivity for Landsat band 11 calculated according to Skokovic et al. 2014 or Yu et al. 2014}
}
\value{
SpatRaster
}
\description{
This function calculates Land Surface Temperature using split-window algorithm
}
\examples{
TIR_10 <- terra::rast(ncol=100, nrow=100)
set.seed(2)
terra::values(TIR_10) = runif(10000, min=27791, max=30878)
TIR_11 <- terra::rast(ncol=100, nrow=100)
set.seed(2)
terra::values(TIR_11) = runif(10000, min=25686, max=28069)
E_10 <- terra::rast(ncol=100, nrow=100)
set.seed(1)
terra::values(E_10) = runif(10000, min=0.96, max=0.99)
E_11 <-terra::rast(ncol=100, nrow=100)
set.seed(2)
terra::values(E_11) = runif(10000, min=0.96, max=0.99)
Ts_SWA <- SWA(TIR_10=TIR_10, TIR_11=TIR_11, tau_10=0.86,
		tau_11=0.87, E_10=E_10, E_11=E_11)
}
\references{
Yu, X., Guo, X. and Wu, Z., 2014. Land surface temperature retrieval from Landsat 8 TIRS—Comparison between radiative transfer equation-based method, split window algorithm and single channel method. Remote sensing, 6(10), pp.9829-9852.
}
