% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{binning}
\alias{binning}
\title{binning}
\usage{
binning(x, y, nbins, xrange = NULL)
}
\arguments{
\item{x}{design matrix, dimension n x d with d in 1:3.}

\item{y}{either a response vector of length n or NULL.}

\item{nbins}{vector of length d containing number of bins for each dimension, may be set to NULL.}

\item{xrange}{range for endpoints of bins for each dimension, either matrix of dimension 2 x d or NULL. xrange is increased if the cube defined does not contain all design points.}
}
\value{
a list with elements:
  \itemize{
    \item x matrix of coordinates of non-empty bin centers
    \item x.freq number of observations in nonempty bins
    \item midpoints.x1 bin centers in dimension 1
    \item midpoints.x2 bin centers in dimension 2
    \item midpoints.x3 bin centers in dimension 3
    \item breaks.x1 break points dimension 1
    \item breaks.x2 break points dimension 2
    \item breaks.x3 break points dimension 3
    \item table.freq number of observations per bin
    \item means means of y in non-empty bins (if y isn't NULL)
    \item devs standard deviations of y in non-empty bins (if y isn't NULL)
  }
}
\description{
Binning in 1D, 2D or 3D.
}
\details{
Copied from package aws which is no longer in CRAN.
Original author:  Joerg Polzehl (polzehl@wias-berlin.de)
who adapted code of function binning in package sm.
}
