% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{julia_setup}
\alias{julia_setup}
\title{Do initial setup for the JuliaCall package.}
\usage{
julia_setup(
  JULIA_HOME = NULL,
  verbose = TRUE,
  installJulia = FALSE,
  install = TRUE,
  force = FALSE,
  useRCall = TRUE,
  rebuild = FALSE,
  sysimage_path = NULL,
  version = "latest"
)
}
\arguments{
\item{JULIA_HOME}{the file folder which contains julia binary,
if not set, JuliaCall will look at the global option JULIA_HOME,
if the global option is not set,
JuliaCall will then look at the environmental variable JULIA_HOME,
if still not found, JuliaCall will try to use
the julia in path.}

\item{verbose}{whether to print out detailed information
about \code{julia_setup}.}

\item{installJulia}{whether to install julia automatically when julia is not found,
whose default value is FALSE.}

\item{install}{whether to execute installation script for dependent julia packages, whose default value is TRUE;
but can be set to FALSE to save startup time when no installation of dependent julia packages is needed.}

\item{force}{whether to force julia_setup to execute again.}

\item{useRCall}{whether or not you want to use RCall.jl in julia,
which is an amazing package to access R in julia.}

\item{rebuild}{whether to rebuild RCall.jl, whose default value is FALSE to save startup time.
If a new version of R is used, then this parameter needs to be set to TRUE.}

\item{sysimage_path}{path to the precompiled custom sys image.
Path can be either an absolute path or relative to the current directory.}

\item{version}{the version of Julia to install. Defaults to "latest", which is the latest 
released version of Julia. You can use "1.10" for example for Julia v1.10.}
}

\value{
The julia interface, which is an environment with the necessary methods
  like command, source and things like that to communicate with julia.
}
\description{
\code{julia_setup} does the initial setup for the JuliaCall package.
    It setups automatic type conversion, Julia display systems, etc,
    and is necessary for every new R session to use the package.
    If not carried out manually, it will be invoked automatically before other julia_xxx functions.
}
\examples{

if (identical(Sys.getenv("AUTO_JULIA_INSTALL"), "true")) { ## julia_setup is quite time consuming
  julia <- julia_setup(installJulia = TRUE)
}

}
