% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{julia_eval}
\alias{julia_eval}
\title{Evaluate string commands in julia and get the result back in R.}
\usage{
julia_eval(cmd, need_return = c("R", "Julia"))
}
\arguments{
\item{cmd}{the command string you want to evaluate in julia.}

\item{need_return}{whether you want julia to return value as an R object or
a wrapper for julia object.}
}
\value{
the R object automatically converted from julia object.
}
\description{
\code{julia_eval} evaluates string commands in julia and
returns the result to R.
The returning julia object will be automatically converted
to an R object or a JuliaObject wrapper,
see the documentation of the argument `need_return` for more details.
`julia_eval` will not invoke julia display system.
If you don't need the returning result in R or
you want to invoke the julia display system, you can
use \code{julia_command}.
}
\examples{

if (identical(Sys.getenv("AUTO_JULIA_INSTALL"), "true")) { ## julia_setup is quite time consuming
  ## doing initialization and automatic installation of Julia if necessary
  julia_setup(installJulia = TRUE)
  julia_eval("sqrt(2)")
}

}
