% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-mid.R
\docType{methods}
\name{mid}
\alias{mid}
\alias{mid,IntervalData-method}
\alias{mid,IntervalList-method}
\alias{mid,IntervalMatrix-method}
\alias{mid<-}
\alias{mid<-,IntervalData-method}
\alias{mid<-,IntervalList-method}
\alias{mid<-,IntervalMatrix-method}
\title{Extract and replace the mid-points of interval-valued objects}
\usage{
\S4method{mid}{IntervalData}(object)

\S4method{mid}{IntervalList}(object)

\S4method{mid}{IntervalMatrix}(object)

\S4method{mid}{IntervalData}(object) <- value

\S4method{mid}{IntervalList}(object) <- value

\S4method{mid}{IntervalMatrix}(object) <- value
}
\arguments{
\item{object}{A single nonempty compact interval or a list or matrix
with some intervals of this family, that is, an
\code{IntervalData}, \code{IntervalList}, or
\code{IntervalMatrix} instance.}

\item{value}{A \code{numeric} or \code{matrix} object with the new values
of the intervals mid-points.}
}
\value{
On the one hand, \code{mid()} function returns the mid-points of the
intervals contained in \code{IntervalData}, \code{IntervalList}, or
\code{IntervalMatrix} instances stored as a single \code{numeric} value, a
\code{numeric} vector, or a \code{matrix} object, respectively. On the other
hand, \code{mid<-} command does not return any value since it only allows to
replace the \code{mid} slot of the given interval-valued object.
}
\description{
This functions provides customized access to the \code{mid} slot of
\code{IntervalData}, \code{IntervalList}, and \code{IntervalMatrix} objects,
so the mid-points of the intervals can be extracted and replaced. This does
not prevent to use the @ accessor, but does not force others to know the
implementation details.
}
\examples{
## Some mid() function examples

## With IntervalData objects
interval <- IntervalData(0, 1)

mid(interval)
mid(interval) <- 0.75
mid(interval)

## With IntervalList objects
list <- IntervalList(c(1, 3, 5), c(2, 4, 6))

mid(list[c(1, 3)])
mid(list[c(1, 3)]) <- c(1, 3)
mid(list[c(1, 3)])

## With IntervalMatrix objects
m <- IntervalMatrix(matrix(c(1, 5, 2, 6, 6, 2,
                             7, 3, 3, 4, 4, 5), 2, 6))

mid(m[1, 1])
mid(m[1, 1]) <- 2
mid(m[1, 1])

mid(m[1, 1:2])
mid(m[1, 1:2]) <- c(2, 3)
mid(m[1, 1:2])

mid(m[, c(1, 3)])
mid(m[, c(1, 3)]) <- matrix(1:4, 2, 2)
mid(m[, c(1, 3)])

}
\seealso{
For accessing \code{spr} slot of interval-valued objects, \code{\link{spr}()}
function can be used.
}
\author{
José García-García \email{garciagarjose@uniovi.es}
}
