% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntervalList.R
\name{IntervalList}
\alias{IntervalList}
\title{Create an \code{IntervalList} object}
\usage{
IntervalList(x, y = NULL, type = 1)
}
\arguments{
\item{x}{A \code{numeric} vector, \code{matrix} or \code{data.frame}.}

\item{y}{\code{NULL} (default) or a \code{numeric} vector with compatible
dimensions to \code{x}.}

\item{type}{A single real number specifying the characterization that is
being used stored as a unique \code{numeric} value. Only the
following two options are allowed:
\itemize{
\item \code{1}: The \emph{inf/sup}-characterization
is used (default).
\item \code{2}: The \emph{mid/spr}-characterization is used.
}}
}
\value{
This function returns the created \code{IntervalList} object.
}
\description{
For convenience, \code{IntervalList} objects or instances
may be created with this function.
}
\details{
In order to create an \code{IntervalList} object, the information that
defines the intervals of the list (either the lower and upper bounds or
either the mid-points and the spreads) can be given as input to
\code{IntervalList()} function in two different ways. On the one hand, each
type of characterizing point can be stored separately in two \code{numeric}
vectors and then they are passed to the function through \code{x} and
\code{y} arguments. On the other hand, they can be stored jointly in a
\code{matrix} or \code{data.frame} and then only \code{x} argument is used
(\code{y} is left as \code{NULL} as it is defined by default).
}
\examples{
## The following code generates the same list of intervals in four
## different ways by using different characterizations. In particular,
## the following list made up of three intervals is defined,
## {[0, 1], [2, 6], [5, 10] = [0.5 -+ 0.5], [4 -+ 2], [7.5 -+ 2.5]}.

## First, inf/sup-characterization stored in two vectors is used.
list1 <- IntervalList(c(0, 2, 5), c(1, 6, 10)); list1
## Then, mid/spr-characterization stored in two vectors is used.
list2 <- IntervalList(c(0.5, 4, 7.5), c(0.5, 2, 2.5), type = 2); list2
## Then, inf/sup-characterization stored in a matrix is used.
matrix <- matrix(c(0, 2, 5, 1, 6, 10), 3, 2)
list3 <- IntervalList(matrix); list3
## Finally, mid/spr-characterization stored in a data.frame is used.
dataframe <- data.frame(mids = c(0.5, 4, 7.5), sprs = c(0.5, 2, 2.5))
list4 <- IntervalList(dataframe, type = 2); list4
}
\seealso{
For other interval-valued data definition use \code{\link{IntervalData}()}
and \code{\link{IntervalMatrix}()} functions.
}
\author{
José García-García \email{garciagarjose@uniovi.es}
}
