/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.tfloat.quantile;

import cern.colt.list.tfloat.FloatArrayList;
import cern.jet.math.tfloat.FloatArithmetic;
import cern.jet.random.tfloat.engine.FloatRandomEngine;
import cern.jet.stat.tfloat.quantile.ExactFloatQuantileFinder;
import cern.jet.stat.tfloat.quantile.FloatQuantileFinder;
import cern.jet.stat.tfloat.quantile.KnownFloatQuantileEstimator;
import cern.jet.stat.tfloat.quantile.UnknownFloatQuantileEstimator;

public class FloatQuantileFinderFactory {
    protected FloatQuantileFinderFactory() {
    }

    public static long[] known_N_compute_B_and_K(long l, float f, float f2, int n, float[] fArray) {
        fArray[0] = 1.0f;
        if ((double)f <= 0.0) {
            long[] lArray = new long[]{1L, l};
            return lArray;
        }
        if ((double)f >= 1.0 || (double)f2 >= 1.0) {
            long[] lArray = new long[]{2L, 1L};
            return lArray;
        }
        if ((double)f2 > 0.0) {
            return FloatQuantileFinderFactory.known_N_compute_B_and_K_slow(l, f, f2, n, fArray);
        }
        return FloatQuantileFinderFactory.known_N_compute_B_and_K_quick(l, f);
    }

    protected static long[] known_N_compute_B_and_K_quick(long l, float f) {
        long l2;
        long l3;
        int n;
        int n2;
        float f2 = l;
        float f3 = f2 * f * 2.0f;
        int[] nArray = new int[49];
        for (int i = 2; i <= 50; ++i) {
            for (n2 = 3; n2 <= 50 && (double)((float)(n2 - 2) * FloatArithmetic.binomial(i + n2 - 2, (long)(n2 - 1)) - FloatArithmetic.binomial(i + n2 - 3, (long)(n2 - 3)) + FloatArithmetic.binomial(i + n2 - 3, (long)(n2 - 2)) - f3) > 0.0; ++n2) {
            }
            while (n2 <= 50 && (double)((float)(n2 - 2) * FloatArithmetic.binomial(i + n2 - 2, (long)(n2 - 1)) - FloatArithmetic.binomial(i + n2 - 3, (long)(n2 - 3)) + FloatArithmetic.binomial(i + n2 - 3, (long)(n2 - 2)) - f3) <= 0.0) {
                ++n2;
            }
            n = --n2 >= 50 && (double)((float)(n2 - 2) * FloatArithmetic.binomial(i + n2 - 2, (long)(n2 - 1)) - FloatArithmetic.binomial(i + n2 - 3, (long)(n2 - 3)) + FloatArithmetic.binomial(i + n2 - 3, (long)(n2 - 2)) - f3) > 0.0 ? Integer.MIN_VALUE : n2;
            nArray[i - 2] = n;
        }
        long[] lArray = new long[49];
        for (n2 = 2; n2 <= 50; ++n2) {
            float f4;
            n = nArray[n2 - 2];
            long l4 = Long.MAX_VALUE;
            if (n > Integer.MIN_VALUE && (l3 = (long)Math.ceil(f2 / (f4 = FloatArithmetic.binomial(n2 + n - 2, (long)(n - 1))))) <= Long.MAX_VALUE) {
                l4 = l3;
            }
            lArray[n2 - 2] = l4;
        }
        long l5 = Long.MAX_VALUE;
        int n3 = -1;
        for (int i = 2; i <= 50; ++i) {
            long l6;
            if (lArray[i - 2] >= Long.MAX_VALUE || (l6 = (long)i * lArray[i - 2]) >= l5) continue;
            l5 = l6;
            n3 = i;
        }
        if (n3 != -1) {
            l2 = n3;
            l3 = lArray[n3 - 2];
        } else {
            l2 = 1L;
            l3 = l;
        }
        long[] lArray2 = new long[]{l2, l3};
        return lArray2;
    }

    protected static long[] known_N_compute_B_and_K_slow(long l, float f, float f2, int n, float[] fArray) {
        float f3 = l;
        long l2 = 1L;
        long l3 = l;
        float f4 = 1.0f;
        long l4 = l;
        float f5 = (float)Math.log(2.0 * (double)n / (double)f2);
        float f6 = 2.0f * f * f3;
        for (long i = 2L; i < 50L; ++i) {
            for (long j = 3L; j < 50L; ++j) {
                float f7 = FloatArithmetic.binomial(i + j - 2L, j - 1L);
                long l5 = (long)Math.ceil(f3 / f7);
                if (i * l5 < l4 && (float)(j - 2L) * f7 - FloatArithmetic.binomial(i + j - 3L, j - 3L) + FloatArithmetic.binomial(i + j - 3L, j - 2L) <= f6) {
                    l3 = l5;
                    l2 = i;
                    l4 = l3 * i;
                    f4 = 1.0f;
                }
                if (!((double)f2 > 0.0)) continue;
                float f8 = (float)(j - 2L) * FloatArithmetic.binomial(i + j - 2L, j - 1L) - FloatArithmetic.binomial(i + j - 3L, j - 3L) + FloatArithmetic.binomial(i + j - 3L, j - 2L);
                float f9 = f5 / f;
                float f10 = FloatArithmetic.binomial(i + j - 2L, j - 1L);
                float f11 = f5 / (2.0f * f * f);
                float f12 = (float)(0.5 + 0.5 * Math.sqrt(1.0 + 4.0 * (double)f8 / (double)f9));
                long l6 = (long)Math.ceil(f11 * f12 * f12 / f10);
                if (i * l6 >= l4) continue;
                l3 = l6;
                l2 = i;
                l4 = i * l6;
                f4 = f3 * 2.0f * f * f / f5;
            }
        }
        long[] lArray = new long[]{l2, l3};
        fArray[0] = f4;
        return lArray;
    }

    public static FloatQuantileFinder newFloatQuantileFinder(boolean bl, long l, float f, float f2, int n, FloatRandomEngine floatRandomEngine) {
        if ((double)f <= 0.0 || l < 1000L) {
            return new ExactFloatQuantileFinder();
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        if (n < 1) {
            n = 1;
        }
        if ((long)n > l) {
            l = n;
        }
        if (bl) {
            float[] fArray = new float[1];
            long[] lArray = FloatQuantileFinderFactory.known_N_compute_B_and_K(l, f, f2, n, fArray);
            long l2 = lArray[0];
            long l3 = lArray[1];
            if (l2 == 1L) {
                return new ExactFloatQuantileFinder();
            }
            return new KnownFloatQuantileEstimator((int)l2, (int)l3, l, fArray[0], floatRandomEngine);
        }
        long[] lArray = FloatQuantileFinderFactory.unknown_N_compute_B_and_K(f, f2, n);
        long l4 = lArray[0];
        long l5 = lArray[1];
        long l6 = lArray[2];
        float f3 = -1.0f;
        if (lArray[3] == 1L) {
            f3 = f;
        }
        if (l4 == 1L) {
            return new ExactFloatQuantileFinder();
        }
        return new UnknownFloatQuantileEstimator((int)l4, (int)l5, (int)l6, f3, floatRandomEngine);
    }

    public static FloatArrayList newEquiDepthPhis(int n) {
        FloatArrayList floatArrayList = new FloatArrayList(n - 1);
        for (int i = 1; i <= n - 1; ++i) {
            floatArrayList.add((float)i / (float)n);
        }
        return floatArrayList;
    }

    public static long[] unknown_N_compute_B_and_K(float f, float f2, int n) {
        return FloatQuantileFinderFactory.unknown_N_compute_B_and_K_raw(f, f2, n);
    }

    protected static long[] unknown_N_compute_B_and_K_raw(float f, float f2, int n) {
        if ((double)f <= 0.0) {
            long[] lArray = new long[]{1L, Long.MAX_VALUE, Long.MAX_VALUE, 0L};
            return lArray;
        }
        if ((double)f >= 1.0 || (double)f2 >= 1.0) {
            long[] lArray = new long[]{2L, 1L, 3L, 0L};
            return lArray;
        }
        if ((double)f2 <= 0.0) {
            long[] lArray = new long[]{1L, Long.MAX_VALUE, Long.MAX_VALUE, 0L};
            return lArray;
        }
        int n2 = 50;
        int n3 = 50;
        int n4 = 50;
        int n5 = 2;
        long l = Long.MAX_VALUE;
        long l2 = Long.MAX_VALUE;
        long l3 = Long.MAX_VALUE;
        long l4 = Long.MAX_VALUE;
        float f3 = (float)Math.pow(2.0, n4);
        float f4 = (float)(Math.log(2.0 / (double)(f2 / (float)n)) / (2.0 * (double)f * (double)f));
        while (l == Long.MAX_VALUE && n5-- > 0) {
            for (int i = 2; i <= n2; ++i) {
                for (int j = 2; j <= n3; ++j) {
                    long l5;
                    float f5;
                    float f6;
                    float f7;
                    float f8;
                    float f9 = FloatArithmetic.binomial(i + j - 2, (long)(j - 1));
                    float f10 = (float)((double)f4 / Math.min((double)f9, 8.0 * (double)(f8 = FloatArithmetic.binomial(i + j - 3, (long)(j - 1))) / 3.0));
                    float f11 = f10 * f10 + 4.0f * f10 * (f7 = (float)((double)((float)(j + 3) + (f6 = (float)(((double)(f5 = f9 / f8) - 2.0) * ((double)n4 - 2.0) / ((double)(f5 + f3) - 2.0)))) / (2.0 * (double)f)));
                    if ((double)f11 < 0.0) continue;
                    float f12 = (float)Math.sqrt(f11);
                    float f13 = (float)(((double)f10 + 2.0 * (double)f7 + (double)f12) / (2.0 * (double)f7));
                    float f14 = (float)(((double)f10 + 2.0 * (double)f7 - (double)f12) / (2.0 * (double)f7));
                    boolean bl = false;
                    boolean bl2 = false;
                    if (0.0 < (double)f13 && (double)f13 < 1.0) {
                        bl = true;
                    }
                    if (0.0 < (double)f14 && (double)f14 < 1.0) {
                        bl2 = true;
                    }
                    if (!bl && !bl2) continue;
                    float f15 = f13;
                    if (bl && bl2) {
                        f15 = Math.max(f13, f14);
                    } else if (bl2) {
                        f15 = f14;
                    }
                    long l6 = (long)Math.ceil(Math.max((double)(f7 / f15), (double)(j + 1) / (2.0 * (double)f)));
                    if (l6 <= 0L || (l5 = (long)i * l6) >= l4) continue;
                    l2 = l6;
                    l = i;
                    l3 = j;
                    l4 = l5;
                }
            }
            if (l != Long.MAX_VALUE) continue;
            System.out.println("Warning: Computing b and k looks like a lot of work!");
            n2 *= 2;
            n3 *= 2;
            n4 *= 2;
        }
        long[] lArray = new long[4];
        lArray[3] = 0L;
        if (l == Long.MAX_VALUE) {
            lArray[0] = 1L;
            lArray[1] = Long.MAX_VALUE;
            lArray[2] = Long.MAX_VALUE;
        } else {
            lArray[0] = l;
            lArray[1] = l2;
            lArray[2] = l3;
        }
        return lArray;
    }
}

