/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.math.tdcomplex;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexRealProcedure;
import cern.colt.function.tdcomplex.DComplexDComplexRealRealFunction;
import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.function.tdcomplex.DComplexRealDComplexFunction;
import cern.colt.function.tdcomplex.DComplexRealFunction;
import cern.colt.function.tdcomplex.RealDComplexDComplexFunction;
import cern.colt.function.tdcomplex.RealDComplexFunction;
import cern.jet.math.tdcomplex.DComplex;
import cern.jet.math.tdcomplex.DComplexMult;
import cern.jet.math.tdcomplex.DComplexPlusMultFirst;
import cern.jet.math.tdcomplex.DComplexPlusMultSecond;

public class DComplexFunctions {
    public static final DComplexFunctions functions = new DComplexFunctions();
    public static final DComplexRealFunction abs = new DComplexRealFunction(){

        public final double apply(double[] dArray) {
            double d = Math.abs(dArray[0]);
            double d2 = Math.abs(dArray[1]);
            if (d == 0.0 && d2 == 0.0) {
                return 0.0;
            }
            if (d >= d2) {
                double d3 = dArray[1] / dArray[0];
                return d * Math.sqrt(1.0 + d3 * d3);
            }
            double d4 = dArray[0] / dArray[1];
            return d2 * Math.sqrt(1.0 + d4 * d4);
        }
    };
    public static final DComplexDComplexFunction acos = new DComplexDComplexFunction(){

        public final double[] apply(double[] dArray) {
            double[] dArray2 = new double[2];
            double d = 1.0 - (dArray[0] * dArray[0] - dArray[1] * dArray[1]);
            double d2 = -(dArray[0] * dArray[1] + dArray[1] * dArray[0]);
            dArray2[0] = d;
            dArray2[1] = d2;
            dArray2 = DComplex.sqrt(dArray2);
            d = -dArray2[1];
            d2 = dArray2[0];
            dArray2[0] = dArray[0] + d;
            dArray2[1] = dArray[1] + d2;
            d = Math.log(DComplex.abs(dArray2));
            dArray2[0] = d2 = Math.atan2(dArray2[1], dArray2[0]);
            dArray2[1] = -d;
            return dArray2;
        }

        public final double[] apply(double d, double d2) {
            double[] dArray = new double[2];
            double d3 = 1.0 - (d * d - d2 * d2);
            double d4 = -(d * d2 + d2 * d);
            dArray[0] = d3;
            dArray[1] = d4;
            dArray = DComplex.sqrt(dArray);
            d3 = -dArray[1];
            d4 = dArray[0];
            dArray[0] = d + d3;
            dArray[1] = d2 + d4;
            d3 = Math.log(DComplex.abs(dArray));
            dArray[0] = d4 = Math.atan2(dArray[1], dArray[0]);
            dArray[1] = -d3;
            return dArray;
        }
    };
    public static final DComplexRealFunction arg = new DComplexRealFunction(){

        public final double apply(double[] dArray) {
            return Math.atan2(dArray[1], dArray[0]);
        }
    };
    public static final DComplexDComplexFunction asin = new DComplexDComplexFunction(){

        public final double[] apply(double[] dArray) {
            double[] dArray2 = new double[2];
            double d = 1.0 - (dArray[0] * dArray[0] - dArray[1] * dArray[1]);
            double d2 = -(dArray[0] * dArray[1] + dArray[1] * dArray[0]);
            dArray2[0] = d;
            dArray2[1] = d2;
            dArray2 = DComplex.sqrt(dArray2);
            d = -dArray2[1];
            d2 = dArray2[0];
            dArray2[0] = dArray2[0] + d;
            dArray2[1] = dArray2[1] + d2;
            d = Math.log(DComplex.abs(dArray2));
            dArray2[0] = d2 = Math.atan2(dArray2[1], dArray2[0]);
            dArray2[1] = -d;
            return dArray2;
        }

        public final double[] apply(double d, double d2) {
            double[] dArray = new double[2];
            double d3 = 1.0 - (d * d - d2 * d2);
            double d4 = -(d * d2 + d2 * d);
            dArray[0] = d3;
            dArray[1] = d4;
            dArray = DComplex.sqrt(dArray);
            d3 = -dArray[1];
            d4 = dArray[0];
            dArray[0] = dArray[0] + d3;
            dArray[1] = dArray[1] + d4;
            d3 = Math.log(DComplex.abs(dArray));
            dArray[0] = d4 = Math.atan2(dArray[1], dArray[0]);
            dArray[1] = -d3;
            return dArray;
        }
    };
    public static final DComplexDComplexFunction atan = new DComplexDComplexFunction(){

        public final double[] apply(double[] dArray) {
            double[] dArray2 = new double[]{-dArray[0], 1.0 - dArray[1]};
            double d = dArray[0];
            double d2 = 1.0 + dArray[1];
            dArray2 = DComplex.div(dArray2, d, d2);
            d = Math.log(DComplex.abs(dArray2));
            d2 = Math.atan2(dArray2[1], dArray2[0]);
            dArray2[0] = 0.5 * d2;
            dArray2[1] = -0.5 * d;
            return dArray2;
        }

        public final double[] apply(double d, double d2) {
            double[] dArray = new double[]{-d, 1.0 - d2};
            double d3 = d;
            double d4 = 1.0 + d2;
            dArray = DComplex.div(dArray, d3, d4);
            d3 = Math.log(DComplex.abs(dArray));
            d4 = Math.atan2(dArray[1], dArray[0]);
            dArray[0] = 0.5 * d4;
            dArray[1] = -0.5 * d3;
            return dArray;
        }
    };
    public static final DComplexDComplexFunction conj = new DComplexDComplexFunction(){

        public final double[] apply(double[] dArray) {
            double[] dArray2 = new double[]{dArray[0], -dArray[1]};
            return dArray2;
        }

        public final double[] apply(double d, double d2) {
            double[] dArray = new double[]{d, -d2};
            return dArray;
        }
    };
    public static final DComplexDComplexFunction cos = new DComplexDComplexFunction(){

        public final double[] apply(double[] dArray) {
            double[] dArray2 = new double[2];
            double d = -dArray[1];
            double d2 = dArray[0];
            double d3 = Math.exp(d);
            double d4 = d3 * Math.cos(d2);
            double d5 = d3 * Math.sin(d2);
            d3 = Math.exp(-d);
            double d6 = d3 * Math.cos(-d2);
            double d7 = d3 * Math.sin(-d2);
            dArray2[0] = 0.5 * (d4 += d6);
            dArray2[1] = 0.5 * (d5 += d7);
            return dArray2;
        }

        public final double[] apply(double d, double d2) {
            double[] dArray = new double[2];
            double d3 = -d2;
            double d4 = d;
            double d5 = Math.exp(d3);
            double d6 = d5 * Math.cos(d4);
            double d7 = d5 * Math.sin(d4);
            d5 = Math.exp(-d3);
            double d8 = d5 * Math.cos(-d4);
            double d9 = d5 * Math.sin(-d4);
            dArray[0] = 0.5 * (d6 += d8);
            dArray[1] = 0.5 * (d7 += d9);
            return dArray;
        }
    };
    public static final DComplexDComplexFunction exp = new DComplexDComplexFunction(){

        public final double[] apply(double[] dArray) {
            double[] dArray2 = new double[2];
            double d = Math.exp(dArray[0]);
            dArray2[0] = d * Math.cos(dArray[1]);
            dArray2[1] = d * Math.sin(dArray[1]);
            return dArray2;
        }

        public final double[] apply(double d, double d2) {
            double[] dArray = new double[2];
            double d3 = Math.exp(d);
            dArray[0] = d3 * Math.cos(d2);
            dArray[1] = d3 * Math.sin(d2);
            return dArray;
        }
    };
    public static final DComplexDComplexFunction identity = new DComplexDComplexFunction(){

        public final double[] apply(double[] dArray) {
            return dArray;
        }

        public final double[] apply(double d, double d2) {
            return new double[]{d, d2};
        }
    };
    public static final DComplexDComplexFunction inv = new DComplexDComplexFunction(){

        public final double[] apply(double[] dArray) {
            double[] dArray2 = new double[2];
            if (dArray[1] != 0.0) {
                double d = dArray[0] * dArray[0] + dArray[1] * dArray[1];
                dArray2[0] = dArray[0] / d;
                dArray2[1] = -dArray[1] / d;
            } else {
                dArray2[0] = 1.0 / dArray[0];
                dArray2[1] = 0.0;
            }
            return dArray2;
        }

        public final double[] apply(double d, double d2) {
            double[] dArray = new double[2];
            if (d2 != 0.0) {
                if (Math.abs(d) >= Math.abs(dArray[1])) {
                    double d3;
                    dArray[0] = d3 = 1.0 / (d + d2 * (d2 / d));
                    dArray[1] = d3 * (-d2 / d);
                } else {
                    double d4 = 1.0 / (d * (d / d2) + d2);
                    dArray[0] = d4 * (d / d2);
                    dArray[1] = -d4;
                }
            } else {
                dArray[0] = 1.0 / d;
                dArray[1] = 0.0;
            }
            return dArray;
        }
    };
    public static final DComplexDComplexFunction log = new DComplexDComplexFunction(){

        public final double[] apply(double[] dArray) {
            double[] dArray2 = new double[]{Math.log(DComplex.abs(dArray)), DComplex.arg(dArray)};
            return dArray2;
        }

        public final double[] apply(double d, double d2) {
            double[] dArray = new double[]{Math.log(DComplex.abs(d, d2)), DComplex.arg(d, d2)};
            return dArray;
        }
    };
    public static final DComplexDComplexFunction neg = new DComplexDComplexFunction(){

        public final double[] apply(double[] dArray) {
            return new double[]{-dArray[0], -dArray[1]};
        }

        public final double[] apply(double d, double d2) {
            return new double[]{-d, -d2};
        }
    };
    public static final DComplexDComplexFunction sin = new DComplexDComplexFunction(){

        public final double[] apply(double[] dArray) {
            double[] dArray2 = new double[2];
            double d = -dArray[1];
            double d2 = dArray[0];
            double d3 = Math.exp(d);
            double d4 = d3 * Math.cos(d2);
            double d5 = d3 * Math.sin(d2);
            d3 = Math.exp(-d);
            double d6 = d3 * Math.cos(-d2);
            double d7 = d3 * Math.sin(-d2);
            dArray2[0] = 0.5 * (d5 -= d7);
            dArray2[1] = -0.5 * (d4 -= d6);
            return dArray2;
        }

        public final double[] apply(double d, double d2) {
            double[] dArray = new double[2];
            double d3 = -d2;
            double d4 = d;
            double d5 = Math.exp(d3);
            double d6 = d5 * Math.cos(d4);
            double d7 = d5 * Math.sin(d4);
            d5 = Math.exp(-d3);
            double d8 = d5 * Math.cos(-d4);
            double d9 = d5 * Math.sin(-d4);
            dArray[0] = 0.5 * (d7 -= d9);
            dArray[1] = -0.5 * (d6 -= d8);
            return dArray;
        }
    };
    public static final DComplexDComplexFunction sqrt = new DComplexDComplexFunction(){

        public final double[] apply(double[] dArray) {
            double[] dArray2 = new double[2];
            double d = DComplex.abs(dArray);
            if (d > 0.0) {
                if (dArray[0] > 0.0) {
                    double d2;
                    dArray2[0] = d2 = Math.sqrt(0.5 * (d + dArray[0]));
                    dArray2[1] = 0.5 * (dArray[1] / d2);
                } else {
                    double d3 = Math.sqrt(0.5 * (d - dArray[0]));
                    if (dArray[1] < 0.0) {
                        d3 = -d3;
                    }
                    dArray2[0] = 0.5 * (dArray[1] / d3);
                    dArray2[1] = d3;
                }
            } else {
                dArray2[0] = 0.0;
                dArray2[1] = 0.0;
            }
            return dArray2;
        }

        public final double[] apply(double d, double d2) {
            double[] dArray = new double[2];
            double d3 = DComplex.abs(d, d2);
            if (d3 > 0.0) {
                if (d > 0.0) {
                    double d4;
                    dArray[0] = d4 = Math.sqrt(0.5 * (d3 + d));
                    dArray[1] = 0.5 * (d2 / d4);
                } else {
                    double d5 = Math.sqrt(0.5 * (d3 - d));
                    if (d2 < 0.0) {
                        d5 = -d5;
                    }
                    dArray[0] = 0.5 * (d2 / d5);
                    dArray[1] = d5;
                }
            } else {
                dArray[0] = 0.0;
                dArray[1] = 0.0;
            }
            return dArray;
        }
    };
    public static final DComplexDComplexFunction square = new DComplexDComplexFunction(){

        public final double[] apply(double[] dArray) {
            double[] dArray2 = new double[]{dArray[0] * dArray[0] - dArray[1] * dArray[1], dArray[1] * dArray[0] + dArray[0] * dArray[1]};
            return dArray2;
        }

        public final double[] apply(double d, double d2) {
            double[] dArray = new double[]{d * d - d2 * d2, d2 * d + d * d2};
            return dArray;
        }
    };
    public static final DComplexDComplexFunction tan = new DComplexDComplexFunction(){

        public final double[] apply(double[] dArray) {
            double[] dArray2 = new double[2];
            double d = -dArray[1];
            double d2 = dArray[0];
            double d3 = Math.exp(d);
            double d4 = d3 * Math.cos(d2);
            double d5 = d3 * Math.sin(d2);
            d3 = Math.exp(-d);
            double d6 = d3 * Math.cos(-d2);
            double d7 = d3 * Math.sin(-d2);
            double d8 = d4 - d6;
            double d9 = d5 - d7;
            dArray2[0] = 0.5 * d9;
            dArray2[1] = -0.5 * d8;
            d8 = d4 + d6;
            d9 = d5 + d7;
            double d10 = 0.5 * d8;
            double d11 = 0.5 * d9;
            dArray2 = DComplex.div(dArray2, d10, d11);
            return dArray2;
        }

        public final double[] apply(double d, double d2) {
            double[] dArray = new double[2];
            double d3 = -d2;
            double d4 = d;
            double d5 = Math.exp(d3);
            double d6 = d5 * Math.cos(d4);
            double d7 = d5 * Math.sin(d4);
            d5 = Math.exp(-d3);
            double d8 = d5 * Math.cos(-d4);
            double d9 = d5 * Math.sin(-d4);
            double d10 = d6 - d8;
            double d11 = d7 - d9;
            dArray[0] = 0.5 * d11;
            dArray[1] = -0.5 * d10;
            d10 = d6 + d8;
            d11 = d7 + d9;
            double d12 = 0.5 * d10;
            double d13 = 0.5 * d11;
            dArray = DComplex.div(dArray, d12, d13);
            return dArray;
        }
    };
    public static final DComplexDComplexDComplexFunction div = new DComplexDComplexDComplexFunction(){

        public final double[] apply(double[] dArray, double[] dArray2) {
            double d = dArray2[0];
            double d2 = dArray2[1];
            double[] dArray3 = new double[2];
            if (Math.abs(d) >= Math.abs(d2)) {
                double d3 = 1.0 / (d + d2 * (d2 / d));
                dArray3[0] = d3 * (dArray[0] + dArray[1] * (d2 / d));
                dArray3[1] = d3 * (dArray[1] - dArray[0] * (d2 / d));
            } else {
                double d4 = 1.0 / (d * (d / d2) + d2);
                dArray3[0] = d4 * (dArray[0] * (d / d2) + dArray[1]);
                dArray3[1] = d4 * (dArray[1] * (d / d2) - dArray[0]);
            }
            return dArray3;
        }
    };
    public static final DComplexDComplexRealRealFunction equals = new DComplexDComplexRealRealFunction(){

        public final double apply(double[] dArray, double[] dArray2, double d) {
            if (DComplex.abs(dArray[0] - dArray2[0], dArray[1] - dArray2[1]) <= Math.abs(d)) {
                return 1.0;
            }
            return 0.0;
        }
    };
    public static final DComplexDComplexRealProcedure isEqual = new DComplexDComplexRealProcedure(){

        public final boolean apply(double[] dArray, double[] dArray2, double d) {
            return DComplex.abs(dArray[0] - dArray2[0], dArray[1] - dArray2[1]) <= Math.abs(d);
        }
    };
    public static final DComplexDComplexDComplexFunction minus = new DComplexDComplexDComplexFunction(){

        public final double[] apply(double[] dArray, double[] dArray2) {
            double[] dArray3 = new double[]{dArray[0] - dArray2[0], dArray[1] - dArray2[1]};
            return dArray3;
        }
    };
    public static final DComplexDComplexDComplexFunction mult = new DComplexDComplexDComplexFunction(){

        public final double[] apply(double[] dArray, double[] dArray2) {
            double[] dArray3 = new double[]{dArray[0] * dArray2[0] - dArray[1] * dArray2[1], dArray[1] * dArray2[0] + dArray[0] * dArray2[1]};
            return dArray3;
        }
    };
    public static final DComplexDComplexDComplexFunction multConjFirst = new DComplexDComplexDComplexFunction(){

        public final double[] apply(double[] dArray, double[] dArray2) {
            double[] dArray3 = new double[]{dArray[0] * dArray2[0] + dArray[1] * dArray2[1], -dArray[1] * dArray2[0] + dArray[0] * dArray2[1]};
            return dArray3;
        }
    };
    public static final DComplexDComplexDComplexFunction multConjSecond = new DComplexDComplexDComplexFunction(){

        public final double[] apply(double[] dArray, double[] dArray2) {
            double[] dArray3 = new double[]{dArray[0] * dArray2[0] + dArray[1] * dArray2[1], dArray[1] * dArray2[0] - dArray[0] * dArray2[1]};
            return dArray3;
        }
    };
    public static final DComplexDComplexDComplexFunction plus = new DComplexDComplexDComplexFunction(){

        public final double[] apply(double[] dArray, double[] dArray2) {
            double[] dArray3 = new double[]{dArray[0] + dArray2[0], dArray[1] + dArray2[1]};
            return dArray3;
        }
    };
    public static final DComplexRealDComplexFunction pow1 = new DComplexRealDComplexFunction(){

        public final double[] apply(double[] dArray, double d) {
            double[] dArray2 = new double[2];
            double d2 = d * Math.log(DComplex.abs(dArray));
            double d3 = d * DComplex.arg(dArray);
            double d4 = Math.exp(d2);
            dArray2[0] = d4 * Math.cos(d3);
            dArray2[1] = d4 * Math.sin(d3);
            return dArray2;
        }
    };
    public static final RealDComplexDComplexFunction pow2 = new RealDComplexDComplexFunction(){

        public final double[] apply(double d, double[] dArray) {
            double[] dArray2 = new double[2];
            double d2 = Math.log(Math.abs(d));
            double d3 = Math.atan2(0.0, d);
            double d4 = d2 * dArray[0] - d3 * dArray[1];
            double d5 = d2 * dArray[1] + d3 * dArray[0];
            double d6 = Math.exp(d4);
            dArray2[0] = d6 * Math.cos(d5);
            dArray2[1] = d6 * Math.sin(d5);
            return dArray2;
        }
    };
    public static final DComplexDComplexDComplexFunction pow3 = new DComplexDComplexDComplexFunction(){

        public final double[] apply(double[] dArray, double[] dArray2) {
            double[] dArray3 = new double[2];
            double d = Math.log(DComplex.abs(dArray));
            double d2 = DComplex.arg(dArray);
            double d3 = d * dArray2[0] - d2 * dArray2[1];
            double d4 = d * dArray2[1] + d2 * dArray2[0];
            double d5 = Math.exp(d3);
            dArray3[0] = d5 * Math.cos(d4);
            dArray3[1] = d5 * Math.sin(d4);
            return dArray3;
        }
    };

    public static DComplexDComplexFunction bindArg1(final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction, final double[] dArray) {
        return new DComplexDComplexFunction(){

            public final double[] apply(double[] dArray2) {
                return dComplexDComplexDComplexFunction.apply(dArray, dArray2);
            }

            public final double[] apply(double d, double d2) {
                return dComplexDComplexDComplexFunction.apply(dArray, new double[]{d, d2});
            }
        };
    }

    public static DComplexDComplexFunction bindArg2(final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction, final double[] dArray) {
        return new DComplexDComplexFunction(){

            public final double[] apply(double[] dArray2) {
                return dComplexDComplexDComplexFunction.apply(dArray2, dArray);
            }

            public final double[] apply(double d, double d2) {
                return dComplexDComplexDComplexFunction.apply(new double[]{d, d2}, dArray);
            }
        };
    }

    public static DComplexDComplexDComplexFunction chain(final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction, final DComplexDComplexFunction dComplexDComplexFunction, final DComplexDComplexFunction dComplexDComplexFunction2) {
        return new DComplexDComplexDComplexFunction(){

            public final double[] apply(double[] dArray, double[] dArray2) {
                return dComplexDComplexDComplexFunction.apply(dComplexDComplexFunction.apply(dArray), dComplexDComplexFunction2.apply(dArray2));
            }
        };
    }

    public static DComplexDComplexDComplexFunction chain(final DComplexDComplexFunction dComplexDComplexFunction, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction) {
        return new DComplexDComplexDComplexFunction(){

            public final double[] apply(double[] dArray, double[] dArray2) {
                return dComplexDComplexFunction.apply(dComplexDComplexDComplexFunction.apply(dArray, dArray2));
            }
        };
    }

    public static DComplexDComplexFunction chain(final DComplexDComplexFunction dComplexDComplexFunction, final DComplexDComplexFunction dComplexDComplexFunction2) {
        return new DComplexDComplexFunction(){

            public final double[] apply(double[] dArray) {
                return dComplexDComplexFunction.apply(dComplexDComplexFunction2.apply(dArray));
            }

            public final double[] apply(double d, double d2) {
                return dComplexDComplexFunction.apply(dComplexDComplexFunction2.apply(new double[]{d, d2}));
            }
        };
    }

    public static DComplexDComplexFunction constant(final double[] dArray) {
        return new DComplexDComplexFunction(){

            public final double[] apply(double[] dArray2) {
                return dArray;
            }

            public final double[] apply(double d, double d2) {
                return new double[]{d, d2};
            }
        };
    }

    public static DComplexDComplexFunction div(double[] dArray) {
        return DComplexFunctions.mult(DComplex.inv(dArray));
    }

    public static DComplexDComplexFunction div(double d) {
        double[] dArray = new double[]{d, 0.0};
        return DComplexFunctions.mult(DComplex.inv(dArray));
    }

    public static DComplexRealFunction equals(final double[] dArray) {
        return new DComplexRealFunction(){

            public final double apply(double[] dArray2) {
                if (dArray2[0] == dArray[0] && dArray2[1] == dArray[1]) {
                    return 1.0;
                }
                return 0.0;
            }
        };
    }

    public static DComplexProcedure isEqual(final double[] dArray) {
        return new DComplexProcedure(){

            public final boolean apply(double[] dArray2) {
                return dArray2[0] == dArray[0] && dArray2[1] == dArray[1];
            }
        };
    }

    public static DComplexDComplexFunction minus(double[] dArray) {
        double[] dArray2 = new double[]{-dArray[0], -dArray[1]};
        return DComplexFunctions.plus(dArray2);
    }

    public static DComplexDComplexDComplexFunction minusMult(double[] dArray) {
        double[] dArray2 = new double[]{-dArray[0], -dArray[1]};
        return DComplexFunctions.plusMultSecond(dArray2);
    }

    public static DComplexDComplexFunction mult(double[] dArray) {
        return new DComplexMult(dArray);
    }

    public static DComplexDComplexFunction mult(double d) {
        return new DComplexMult(new double[]{d, 0.0});
    }

    public static DComplexDComplexFunction plus(final double[] dArray) {
        return new DComplexDComplexFunction(){

            public final double[] apply(double[] dArray3) {
                double[] dArray2 = new double[]{dArray3[0] + dArray[0], dArray3[1] + dArray[1]};
                return dArray2;
            }

            public final double[] apply(double d, double d2) {
                double[] dArray2 = new double[]{d + dArray[0], d2 + dArray[1]};
                return dArray2;
            }
        };
    }

    public static DComplexDComplexDComplexFunction plusMultSecond(double[] dArray) {
        return new DComplexPlusMultSecond(dArray);
    }

    public static DComplexDComplexDComplexFunction plusMultFirst(double[] dArray) {
        return new DComplexPlusMultFirst(dArray);
    }

    public static DComplexDComplexFunction pow1(final double d) {
        return new DComplexDComplexFunction(){

            public final double[] apply(double[] dArray) {
                double[] dArray2 = new double[2];
                double d4 = d * Math.log(DComplex.abs(dArray));
                double d2 = d * DComplex.arg(dArray);
                double d3 = Math.exp(d4);
                dArray2[0] = d3 * Math.cos(d2);
                dArray2[1] = d3 * Math.sin(d2);
                return dArray2;
            }

            public final double[] apply(double d6, double d2) {
                double[] dArray = new double[2];
                double d3 = d * Math.log(DComplex.abs(d6, d2));
                double d4 = d * DComplex.arg(d6, d2);
                double d5 = Math.exp(d3);
                dArray[0] = d5 * Math.cos(d4);
                dArray[1] = d5 * Math.sin(d4);
                return dArray;
            }
        };
    }

    public static RealDComplexFunction pow2(final double[] dArray) {
        return new RealDComplexFunction(){

            public final double[] apply(double d) {
                double[] dArray2 = new double[2];
                double d2 = Math.log(Math.abs(d));
                double d3 = Math.atan2(0.0, d);
                double d4 = d2 * dArray[0] - d3 * dArray[1];
                double d5 = d2 * dArray[1] + d3 * dArray[0];
                double d6 = Math.exp(d4);
                dArray2[0] = d6 * Math.cos(d5);
                dArray2[1] = d6 * Math.sin(d5);
                return dArray2;
            }
        };
    }

    public static DComplexDComplexFunction pow3(final double[] dArray) {
        return new DComplexDComplexFunction(){

            public final double[] apply(double[] dArray3) {
                double[] dArray2 = new double[2];
                double d = Math.log(DComplex.abs(dArray3));
                double d2 = DComplex.arg(dArray3);
                double d3 = d * dArray[0] - d2 * dArray[1];
                double d4 = d * dArray[1] + d2 * dArray[0];
                double d5 = Math.exp(d3);
                dArray2[0] = d5 * Math.cos(d4);
                dArray2[1] = d5 * Math.sin(d4);
                return dArray2;
            }

            public final double[] apply(double d, double d2) {
                double[] dArray2 = new double[2];
                double d3 = Math.log(DComplex.abs(d, d2));
                double d4 = DComplex.arg(d, d2);
                double d5 = d3 * dArray[0] - d4 * dArray[1];
                double d6 = d3 * dArray[1] + d4 * dArray[0];
                double d7 = Math.exp(d5);
                dArray2[0] = d7 * Math.cos(d6);
                dArray2[1] = d7 * Math.sin(d6);
                return dArray2;
            }
        };
    }

    public static DComplexDComplexFunction random() {
        return new RandomComplexFunction();
    }

    public static DComplexDComplexDComplexFunction swapArgs(final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction) {
        return new DComplexDComplexDComplexFunction(){

            public final double[] apply(double[] dArray, double[] dArray2) {
                return dComplexDComplexDComplexFunction.apply(dArray2, dArray);
            }
        };
    }

    private static class RandomComplexFunction
    implements DComplexDComplexFunction {
        private RandomComplexFunction() {
        }

        public double[] apply(double[] dArray) {
            return new double[]{Math.random(), Math.random()};
        }

        public double[] apply(double d, double d2) {
            return new double[]{Math.random(), Math.random()};
        }
    }
}

