/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.algo;

import cern.colt.GenericSorting;
import cern.colt.PersistentObject;
import cern.colt.Sorting;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.function.tlong.LongComparator;
import cern.colt.matrix.AbstractFormatter;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.algo.LongMatrix1DComparator;
import cern.colt.matrix.tlong.algo.LongMatrix2DComparator;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;

public class LongSorting
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final LongSorting quickSort = new LongSorting();
    public static final LongSorting mergeSort = new LongSorting(){
        private static final long serialVersionUID = 1L;

        protected void runSort(int[] nArray, int n, int n2, IntComparator intComparator) {
            Sorting.mergeSort(nArray, n, n2, intComparator);
        }

        protected void runSort(int n, int n2, IntComparator intComparator, Swapper swapper) {
            GenericSorting.mergeSort(n, n2, intComparator, swapper);
        }
    };

    protected LongSorting() {
    }

    protected void runSort(int[] nArray, int n, int n2, IntComparator intComparator) {
        Sorting.parallelQuickSort(nArray, n, n2, intComparator);
    }

    protected void runSort(int n, int n2, IntComparator intComparator, Swapper swapper) {
        GenericSorting.quickSort(n, n2, intComparator, swapper);
    }

    public LongMatrix1D sort(LongMatrix1D longMatrix1D) {
        return longMatrix1D.viewSelection(this.sortIndex(longMatrix1D));
    }

    public int[] sortIndex(final LongMatrix1D longMatrix1D) {
        int[] nArray = new int[(int)longMatrix1D.size()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        IntComparator intComparator = null;
        if (longMatrix1D instanceof DenseLongMatrix1D) {
            final long[] lArray = (long[])longMatrix1D.elements();
            final int n2 = (int)longMatrix1D.index(0);
            final int n3 = longMatrix1D.stride();
            intComparator = new IntComparator(){

                public int compare(int n, int n22) {
                    int n32 = n2 + n * n3;
                    long l = lArray[n32];
                    int n4 = n2 + n22 * n3;
                    long l2 = lArray[n4];
                    return l < l2 ? -1 : (l == l2 ? 0 : 1);
                }
            };
        } else {
            intComparator = new IntComparator(){

                public int compare(int n, int n2) {
                    long l;
                    long l2 = longMatrix1D.getQuick(n);
                    return l2 < (l = longMatrix1D.getQuick(n2)) ? -1 : (l2 == l ? 0 : 1);
                }
            };
        }
        this.runSort(nArray, 0, nArray.length, intComparator);
        return nArray;
    }

    public LongMatrix1D sort(LongMatrix1D longMatrix1D, LongComparator longComparator) {
        return longMatrix1D.viewSelection(this.sortIndex(longMatrix1D, longComparator));
    }

    public int[] sortIndex(final LongMatrix1D longMatrix1D, final LongComparator longComparator) {
        int[] nArray = new int[(int)longMatrix1D.size()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        IntComparator intComparator = null;
        if (longMatrix1D instanceof DenseLongMatrix1D) {
            final long[] lArray = (long[])longMatrix1D.elements();
            final int n2 = (int)longMatrix1D.index(0);
            final int n3 = longMatrix1D.stride();
            intComparator = new IntComparator(){

                public int compare(int n, int n22) {
                    int n32 = n2 + n * n3;
                    int n4 = n2 + n22 * n3;
                    return longComparator.compare(lArray[n32], lArray[n4]);
                }
            };
        } else {
            intComparator = new IntComparator(){

                public int compare(int n, int n2) {
                    return longComparator.compare(longMatrix1D.getQuick(n), longMatrix1D.getQuick(n2));
                }
            };
        }
        this.runSort(nArray, 0, nArray.length, intComparator);
        return nArray;
    }

    public LongMatrix2D sort(LongMatrix2D longMatrix2D, final long[] lArray) {
        int n = longMatrix2D.rows();
        if (lArray.length != n) {
            throw new IndexOutOfBoundsException("aggregates.length != matrix.rows()");
        }
        final int[] nArray = new int[n];
        int n2 = n;
        while (--n2 >= 0) {
            nArray[n2] = n2;
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                long l = lArray[n];
                long l2 = lArray[n2];
                return l < l2 ? -1 : (l == l2 ? 0 : 1);
            }
        };
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                int n3 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n3;
                long l = lArray[n];
                lArray[n] = lArray[n2];
                lArray[n2] = l;
            }
        };
        this.runSort(0, n, intComparator, swapper);
        return longMatrix2D.viewSelection(nArray, null);
    }

    public LongMatrix2D sort(LongMatrix2D longMatrix2D, int n) {
        if (n < 0 || n >= longMatrix2D.columns()) {
            throw new IndexOutOfBoundsException("column=" + n + ", matrix=" + AbstractFormatter.shape(longMatrix2D));
        }
        int[] nArray = new int[longMatrix2D.rows()];
        int n2 = nArray.length;
        while (--n2 >= 0) {
            nArray[n2] = n2;
        }
        final LongMatrix1D longMatrix1D = longMatrix2D.viewColumn(n);
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                long l;
                long l2 = longMatrix1D.getQuick(n);
                return l2 < (l = longMatrix1D.getQuick(n2)) ? -1 : (l2 == l ? 0 : 1);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return longMatrix2D.viewSelection(nArray, null);
    }

    public LongMatrix2D sort(LongMatrix2D longMatrix2D, final LongMatrix1DComparator longMatrix1DComparator) {
        int[] nArray = new int[longMatrix2D.rows()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        final LongMatrix1D[] longMatrix1DArray = new LongMatrix1D[longMatrix2D.rows()];
        int n2 = longMatrix1DArray.length;
        while (--n2 >= 0) {
            longMatrix1DArray[n2] = longMatrix2D.viewRow(n2);
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return longMatrix1DComparator.compare(longMatrix1DArray[n], longMatrix1DArray[n2]);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return longMatrix2D.viewSelection(nArray, null);
    }

    public LongMatrix3D sort(LongMatrix3D longMatrix3D, int n, int n2) {
        if (n < 0 || n >= longMatrix3D.rows()) {
            throw new IndexOutOfBoundsException("row=" + n + ", matrix=" + AbstractFormatter.shape(longMatrix3D));
        }
        if (n2 < 0 || n2 >= longMatrix3D.columns()) {
            throw new IndexOutOfBoundsException("column=" + n2 + ", matrix=" + AbstractFormatter.shape(longMatrix3D));
        }
        int[] nArray = new int[longMatrix3D.slices()];
        int n3 = nArray.length;
        while (--n3 >= 0) {
            nArray[n3] = n3;
        }
        final LongMatrix1D longMatrix1D = longMatrix3D.viewRow(n).viewColumn(n2);
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                long l;
                long l2 = longMatrix1D.getQuick(n);
                return l2 < (l = longMatrix1D.getQuick(n2)) ? -1 : (l2 == l ? 0 : 1);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return longMatrix3D.viewSelection(nArray, null, null);
    }

    public LongMatrix3D sort(LongMatrix3D longMatrix3D, final LongMatrix2DComparator longMatrix2DComparator) {
        int[] nArray = new int[longMatrix3D.slices()];
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = n;
        }
        final LongMatrix2D[] longMatrix2DArray = new LongMatrix2D[longMatrix3D.slices()];
        int n2 = longMatrix2DArray.length;
        while (--n2 >= 0) {
            longMatrix2DArray[n2] = longMatrix3D.viewSlice(n2);
        }
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                return longMatrix2DComparator.compare(longMatrix2DArray[n], longMatrix2DArray[n2]);
            }
        };
        this.runSort(nArray, 0, nArray.length, intComparator);
        return longMatrix3D.viewSelection(nArray, null, null);
    }
}

