/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat;

import cern.colt.PersistentObject;
import cern.colt.list.tfloat.AbstractFloatList;
import cern.colt.list.tfloat.FloatArrayList;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.SparseFloatMatrix1D;
import cern.jet.math.tfloat.FloatFunctions;
import cern.jet.random.tfloat.engine.FloatMersenneTwister;
import cern.jet.random.tfloat.sampling.FloatRandomSamplingAssistant;

public class FloatFactory1D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final FloatFactory1D dense = new FloatFactory1D();
    public static final FloatFactory1D sparse = new FloatFactory1D();

    protected FloatFactory1D() {
    }

    public FloatMatrix1D append(FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) {
        FloatMatrix1D floatMatrix1D3 = this.make((int)(floatMatrix1D.size() + floatMatrix1D2.size()));
        floatMatrix1D3.viewPart(0, (int)floatMatrix1D.size()).assign(floatMatrix1D);
        floatMatrix1D3.viewPart((int)floatMatrix1D.size(), (int)floatMatrix1D2.size()).assign(floatMatrix1D2);
        return floatMatrix1D3;
    }

    public FloatMatrix1D ascending(int n) {
        return this.descending(n).assign(FloatFunctions.chain(FloatFunctions.neg, FloatFunctions.minus(n)));
    }

    public FloatMatrix1D descending(int n) {
        FloatMatrix1D floatMatrix1D = this.make(n);
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            floatMatrix1D.setQuick(n3, n2++);
        }
        return floatMatrix1D;
    }

    public FloatMatrix1D make(AbstractFloatList abstractFloatList) {
        int n = abstractFloatList.size();
        FloatMatrix1D floatMatrix1D = this.make(n);
        int n2 = n;
        while (--n2 >= 0) {
            floatMatrix1D.set(n2, abstractFloatList.get(n2));
        }
        return floatMatrix1D;
    }

    public FloatMatrix1D make(float[] fArray) {
        if (this == sparse) {
            return new SparseFloatMatrix1D(fArray);
        }
        return new DenseFloatMatrix1D(fArray);
    }

    public FloatMatrix1D make(FloatMatrix1D[] floatMatrix1DArray) {
        if (floatMatrix1DArray.length == 0) {
            return this.make(0);
        }
        int n = 0;
        for (int i = 0; i < floatMatrix1DArray.length; ++i) {
            n = (int)((long)n + floatMatrix1DArray[i].size());
        }
        FloatMatrix1D floatMatrix1D = this.make(n);
        n = 0;
        for (int i = 0; i < floatMatrix1DArray.length; ++i) {
            floatMatrix1D.viewPart(n, (int)floatMatrix1DArray[i].size()).assign(floatMatrix1DArray[i]);
            n = (int)((long)n + floatMatrix1DArray[i].size());
        }
        return floatMatrix1D;
    }

    public FloatMatrix1D make(int n) {
        if (this == sparse) {
            return new SparseFloatMatrix1D(n);
        }
        return new DenseFloatMatrix1D(n);
    }

    public FloatMatrix1D make(int n, float f) {
        return this.make(n).assign(f);
    }

    public FloatMatrix1D random(int n) {
        return this.make(n).assign(FloatFunctions.random());
    }

    public FloatMatrix1D repeat(FloatMatrix1D floatMatrix1D, int n) {
        int n2 = (int)floatMatrix1D.size();
        FloatMatrix1D floatMatrix1D2 = this.make(n * n2);
        int n3 = n;
        while (--n3 >= 0) {
            floatMatrix1D2.viewPart(n2 * n3, n2).assign(floatMatrix1D);
        }
        return floatMatrix1D2;
    }

    public FloatMatrix1D sample(int n, float f, float f2) {
        float f3 = 1.0E-5f;
        if (f2 < 0.0f - f3 || f2 > 1.0f + f3) {
            throw new IllegalArgumentException();
        }
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        FloatMatrix1D floatMatrix1D = this.make(n);
        int n2 = Math.round((float)n * f2);
        if (n2 == 0) {
            return floatMatrix1D;
        }
        FloatRandomSamplingAssistant floatRandomSamplingAssistant = new FloatRandomSamplingAssistant(n2, n, new FloatMersenneTwister());
        int n3 = n;
        while (--n3 >= 0) {
            if (!floatRandomSamplingAssistant.sampleNextElement()) continue;
            floatMatrix1D.setQuick(n3, f);
        }
        return floatMatrix1D;
    }

    public FloatArrayList toList(FloatMatrix1D floatMatrix1D) {
        int n = (int)floatMatrix1D.size();
        FloatArrayList floatArrayList = new FloatArrayList(n);
        floatArrayList.setSize(n);
        int n2 = n;
        while (--n2 >= 0) {
            floatArrayList.setQuick(n2, floatMatrix1D.get(n2));
        }
        return floatArrayList;
    }
}

