/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex;

import cern.colt.function.tfcomplex.FComplexProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.FComplexMatrix2D;
import cern.colt.matrix.tfcomplex.FComplexMatrix3D;
import cern.colt.matrix.tfloat.FloatFactory1D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.jet.math.tfcomplex.FComplex;
import cern.jet.math.tfcomplex.FComplexFunctions;
import cern.jet.math.tfloat.FloatFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import junit.framework.TestCase;

public abstract class FComplexMatrix1DTest
extends TestCase {
    protected FComplexMatrix1D A;
    protected FComplexMatrix1D B;
    protected int SIZE = 170;
    protected float TOL = 0.001f;
    protected FloatFunctions F = FloatFunctions.functions;

    public FComplexMatrix1DTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.createMatrices();
        this.populateMatrices();
    }

    protected abstract void createMatrices() throws Exception;

    protected void populateMatrices() {
        int n;
        ConcurrencyUtils.setThreadsBeginN_1D(1);
        for (n = 0; n < (int)this.A.size(); ++n) {
            this.A.setQuick(n, new float[]{(float)Math.random(), (float)Math.random()});
        }
        for (n = 0; n < (int)this.B.size(); ++n) {
            this.B.setQuick(n, new float[]{(float)Math.random(), (float)Math.random()});
        }
    }

    protected void tearDown() throws Exception {
        this.B = null;
        this.A = null;
    }

    public void testAggregateFloatFloatFunctionFloatFunction() {
        float[] fArray = new float[2];
        for (int i = 0; i < (int)this.A.size(); ++i) {
            fArray = FComplex.plus(fArray, FComplex.square(this.A.getQuick(i)));
        }
        float[] fArray2 = this.A.aggregate(FComplexFunctions.plus, FComplexFunctions.square);
        this.assertEquals(fArray, fArray2, this.TOL);
    }

    public void testAggregateComplexMatrix1FComplexComplexFunctionComplexComplexFunction() {
        float[] fArray = this.A.aggregate(this.B, FComplexFunctions.plus, FComplexFunctions.mult);
        float[] fArray2 = new float[2];
        for (int i = 0; i < (int)this.A.size(); ++i) {
            fArray2 = FComplex.plus(fArray2, FComplex.mult(this.A.getQuick(i), this.B.getQuick(i)));
        }
        this.assertEquals(fArray2, fArray, this.TOL);
    }

    public void testAssignComplexComplexFunction() {
        FComplexMatrix1D fComplexMatrix1D = this.A.copy();
        this.A.assign(FComplexFunctions.acos);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            float[] fArray = FComplex.acos(fComplexMatrix1D.getQuick(i));
            this.assertEquals(fArray, this.A.getQuick(i), this.TOL);
        }
    }

    public void testAssignComplexMatrix1D() {
        this.A.assign(this.B);
        FComplexMatrix1DTest.assertTrue((this.A.size() == this.B.size() ? 1 : 0) != 0);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            this.assertEquals(this.B.getQuick(i), this.A.getQuick(i), this.TOL);
        }
    }

    public void testAssignComplexMatrix1FComplexComplexFunction() {
        FComplexMatrix1D fComplexMatrix1D = this.A.copy();
        this.A.assign(this.B, FComplexFunctions.div);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            this.assertEquals(FComplex.div(fComplexMatrix1D.getQuick(i), this.B.getQuick(i)), this.A.getQuick(i), this.TOL);
        }
    }

    public void testAssignComplexProcedureComplexComplexFunction() {
        FComplexProcedure fComplexProcedure = new FComplexProcedure(){

            public boolean apply(float[] fArray) {
                return (double)FComplex.abs(fArray) > 0.1;
            }
        };
        FComplexMatrix1D fComplexMatrix1D = this.A.copy();
        this.A.assign(fComplexProcedure, FComplexFunctions.tan);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            if ((double)FComplex.abs(fComplexMatrix1D.getQuick(i)) > 0.1) {
                this.assertEquals(FComplex.tan(fComplexMatrix1D.getQuick(i)), this.A.getQuick(i), this.TOL);
                continue;
            }
            this.assertEquals(fComplexMatrix1D.getQuick(i), this.A.getQuick(i), this.TOL);
        }
    }

    public void testAssignComplexProcedureFloatArray() {
        FComplexProcedure fComplexProcedure = new FComplexProcedure(){

            public boolean apply(float[] fArray) {
                return (double)FComplex.abs(fArray) > 0.1;
            }
        };
        FComplexMatrix1D fComplexMatrix1D = this.A.copy();
        float[] fArray = new float[]{-1.0f, -1.0f};
        this.A.assign(fComplexProcedure, fArray);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            if ((double)FComplex.abs(fComplexMatrix1D.getQuick(i)) > 0.1) {
                this.assertEquals(fArray, this.A.getQuick(i), this.TOL);
                continue;
            }
            this.assertEquals(fComplexMatrix1D.getQuick(i), this.A.getQuick(i), this.TOL);
        }
    }

    public void testAssignComplexRealFunction() {
        FComplexMatrix1D fComplexMatrix1D = this.A.copy();
        this.A.assign(FComplexFunctions.abs);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            float[] fArray = this.A.getQuick(i);
            FComplexMatrix1DTest.assertEquals((float)FComplex.abs(fComplexMatrix1D.getQuick(i)), (float)fArray[0], (float)this.TOL);
            FComplexMatrix1DTest.assertEquals((float)0.0f, (float)fArray[1], (float)this.TOL);
        }
    }

    public void testAssignFloatArray() {
        int n;
        float[] fArray = new float[2 * (int)this.A.size()];
        for (n = 0; n < 2 * (int)this.A.size(); ++n) {
            fArray[n] = (float)Math.random();
        }
        this.A.assign(fArray);
        for (n = 0; n < (int)this.A.size(); ++n) {
            float[] fArray2 = this.A.getQuick(n);
            FComplexMatrix1DTest.assertEquals((float)fArray[2 * n], (float)fArray2[0], (float)this.TOL);
            FComplexMatrix1DTest.assertEquals((float)fArray[2 * n + 1], (float)fArray2[1], (float)this.TOL);
        }
    }

    public void testAssignFloatFloat() {
        float f = (float)Math.random();
        float f2 = (float)Math.random();
        this.A.assign(f, f2);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            float[] fArray = this.A.getQuick(i);
            FComplexMatrix1DTest.assertEquals((float)f, (float)fArray[0], (float)this.TOL);
            FComplexMatrix1DTest.assertEquals((float)f2, (float)fArray[1], (float)this.TOL);
        }
    }

    public void testAssignImaginary() {
        FComplexMatrix1D fComplexMatrix1D = this.A.copy();
        FloatMatrix1D floatMatrix1D = FloatFactory1D.dense.random((int)this.A.size());
        this.A.assignImaginary(floatMatrix1D);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            float[] fArray = this.A.getQuick(i);
            FComplexMatrix1DTest.assertEquals((float)fComplexMatrix1D.getQuick(i)[0], (float)fArray[0], (float)this.TOL);
            FComplexMatrix1DTest.assertEquals((float)floatMatrix1D.getQuick(i), (float)fArray[1], (float)this.TOL);
        }
    }

    public void testAssignReal() {
        FComplexMatrix1D fComplexMatrix1D = this.A.copy();
        FloatMatrix1D floatMatrix1D = FloatFactory1D.dense.random((int)this.A.size());
        this.A.assignReal(floatMatrix1D);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            float[] fArray = this.A.getQuick(i);
            FComplexMatrix1DTest.assertEquals((float)fComplexMatrix1D.getQuick(i)[1], (float)fArray[1], (float)this.TOL);
            FComplexMatrix1DTest.assertEquals((float)floatMatrix1D.getQuick(i), (float)fArray[0], (float)this.TOL);
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        FComplexMatrix1DTest.assertEquals((int)((int)this.A.size()), (int)n);
    }

    public void testEqualsFloat() {
        float[] fArray = new float[]{1.0f, 2.0f};
        this.A.assign(fArray[0], fArray[1]);
        boolean bl = this.A.equals(fArray);
        FComplexMatrix1DTest.assertTrue((boolean)bl);
        bl = this.A.equals(new float[]{2.0f, 2.0f});
        FComplexMatrix1DTest.assertFalse((boolean)bl);
    }

    public void testEqualsObject() {
        boolean bl = this.A.equals(this.A);
        FComplexMatrix1DTest.assertTrue((boolean)bl);
        bl = this.A.equals(this.B);
        FComplexMatrix1DTest.assertFalse((boolean)bl);
    }

    public void testGetImaginaryPart() {
        FloatMatrix1D floatMatrix1D = this.A.getImaginaryPart();
        for (int i = 0; i < (int)this.A.size(); ++i) {
            FComplexMatrix1DTest.assertEquals((float)this.A.getQuick(i)[1], (float)floatMatrix1D.getQuick(i), (float)this.TOL);
        }
    }

    public void testGetRealPart() {
        FloatMatrix1D floatMatrix1D = this.A.getRealPart();
        for (int i = 0; i < (int)this.A.size(); ++i) {
            FComplexMatrix1DTest.assertEquals((float)this.A.getQuick(i)[0], (float)floatMatrix1D.getQuick(i), (float)this.TOL);
        }
    }

    public void testGetNonZerosIntArrayListArrayListOffloat() {
        IntArrayList intArrayList = new IntArrayList();
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        this.A.getNonZeros(intArrayList, arrayList);
        FComplexMatrix1DTest.assertEquals((int)((int)this.A.size()), (int)intArrayList.size());
        FComplexMatrix1DTest.assertEquals((int)((int)this.A.size()), (int)arrayList.size());
        for (int i = 0; i < (int)this.A.size(); ++i) {
            this.assertEquals(this.A.getQuick(intArrayList.get(i)), arrayList.get(i), this.TOL);
            FComplexMatrix1DTest.assertTrue((arrayList.get(i)[0] != 0.0f || arrayList.get(i)[1] != 0.0f ? 1 : 0) != 0);
        }
    }

    public void testReshapeIntInt() {
        int n = 10;
        int n2 = 17;
        FComplexMatrix2D fComplexMatrix2D = this.A.reshape(n, n2);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.assertEquals(this.A.getQuick(n3++), fComplexMatrix2D.getQuick(j, i), this.TOL);
            }
        }
    }

    public void testReshapeIntIntInt() {
        int n = 2;
        int n2 = 5;
        int n3 = 17;
        FComplexMatrix3D fComplexMatrix3D = this.A.reshape(n, n2, n3);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    this.assertEquals(this.A.getQuick(n4++), fComplexMatrix3D.getQuick(i, k, j), this.TOL);
                }
            }
        }
    }

    public void testSwap() {
        FComplexMatrix1D fComplexMatrix1D = this.A.copy();
        FComplexMatrix1D fComplexMatrix1D2 = this.B.copy();
        this.A.swap(this.B);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            this.assertEquals(fComplexMatrix1D2.getQuick(i), this.A.getQuick(i), this.TOL);
            this.assertEquals(fComplexMatrix1D.getQuick(i), this.B.getQuick(i), this.TOL);
        }
    }

    public void testToArray() {
        float[] fArray = this.A.toArray();
        for (int i = 0; i < (int)this.A.size(); ++i) {
            float[] fArray2 = this.A.getQuick(i);
            FComplexMatrix1DTest.assertEquals((float)fArray2[0], (float)fArray[2 * i], (float)this.TOL);
            FComplexMatrix1DTest.assertEquals((float)fArray2[1], (float)fArray[2 * i + 1], (float)this.TOL);
        }
    }

    public void testToArrayFloatArray() {
        float[] fArray = new float[2 * (int)this.A.size()];
        this.A.toArray(fArray);
        for (int i = 0; i < (int)this.A.size(); ++i) {
            float[] fArray2 = this.A.getQuick(i);
            FComplexMatrix1DTest.assertEquals((float)fArray2[0], (float)fArray[2 * i], (float)this.TOL);
            FComplexMatrix1DTest.assertEquals((float)fArray2[1], (float)fArray[2 * i + 1], (float)this.TOL);
        }
    }

    public void testViewFlip() {
        FComplexMatrix1D fComplexMatrix1D = this.A.viewFlip();
        for (int i = 0; i < (int)this.A.size(); ++i) {
            this.assertEquals(this.A.getQuick((int)this.A.size() - 1 - i), fComplexMatrix1D.getQuick(i), this.TOL);
        }
    }

    public void testViewPart() {
        FComplexMatrix1D fComplexMatrix1D = this.A.viewPart((int)this.A.size() / 2, (int)this.A.size() / 3);
        for (int i = 0; i < (int)this.A.size() / 3; ++i) {
            this.assertEquals(this.A.getQuick((int)this.A.size() / 2 + i), fComplexMatrix1D.getQuick(i), this.TOL);
        }
    }

    public void testViewSelectionComplexProcedure() {
        FComplexMatrix1D fComplexMatrix1D = this.A.viewSelection(new FComplexProcedure(){

            public boolean apply(float[] fArray) {
                return fArray[0] < fArray[1];
            }
        });
        int n = 0;
        while ((long)n < fComplexMatrix1D.size()) {
            float[] fArray = fComplexMatrix1D.getQuick(n);
            if (fArray[0] >= fArray[1]) {
                FComplexMatrix1DTest.fail();
            }
            ++n;
        }
    }

    public void testViewSelectionIntArray() {
        int[] nArray = new int[]{(int)this.A.size() / 6, (int)this.A.size() / 5, (int)this.A.size() / 4, (int)this.A.size() / 3, (int)this.A.size() / 2};
        FComplexMatrix1D fComplexMatrix1D = this.A.viewSelection(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            this.assertEquals(this.A.getQuick(nArray[i]), fComplexMatrix1D.getQuick(i), this.TOL);
        }
    }

    public void testViewStrides() {
        int n = 3;
        FComplexMatrix1D fComplexMatrix1D = this.A.viewStrides(n);
        int n2 = 0;
        while ((long)n2 < fComplexMatrix1D.size()) {
            this.assertEquals(this.A.getQuick(n2 * n), fComplexMatrix1D.getQuick(n2), this.TOL);
            ++n2;
        }
    }

    public void testZDotProductComplexMatrix1D() {
        float[] fArray = this.A.zDotProduct(this.B);
        float[] fArray2 = new float[2];
        for (int i = 0; i < (int)this.A.size(); ++i) {
            fArray2 = FComplex.plus(fArray2, FComplex.mult(this.A.getQuick(i), FComplex.conj(this.B.getQuick(i))));
        }
        this.assertEquals(fArray2, fArray, this.TOL);
    }

    public void testZDotProductComplexMatrix1DIntInt() {
        float[] fArray = this.A.zDotProduct(this.B, 5, (int)this.B.size() - 10);
        float[] fArray2 = new float[2];
        for (int i = 5; i < (int)this.A.size() - 5; ++i) {
            fArray2 = FComplex.plus(fArray2, FComplex.mult(this.A.getQuick(i), FComplex.conj(this.B.getQuick(i))));
        }
        this.assertEquals(fArray2, fArray, this.TOL);
    }

    public void testZDotProductComplexMatrix1DIntIntIntArrayList() {
        IntArrayList intArrayList = new IntArrayList();
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        this.B.getNonZeros(intArrayList, arrayList);
        float[] fArray = this.A.zDotProduct(this.B, 5, (int)this.B.size() - 10, intArrayList);
        float[] fArray2 = new float[2];
        for (int i = 5; i < (int)this.A.size() - 5; ++i) {
            fArray2 = FComplex.plus(fArray2, FComplex.mult(this.A.getQuick(i), FComplex.conj(this.B.getQuick(i))));
        }
        this.assertEquals(fArray2, fArray, this.TOL);
    }

    public void testZSum() {
        float[] fArray = this.A.zSum();
        float[] fArray2 = new float[2];
        for (int i = 0; i < (int)this.A.size(); ++i) {
            fArray2 = FComplex.plus(fArray2, this.A.getQuick(i));
        }
        this.assertEquals(fArray2, fArray, this.TOL);
    }

    protected void assertEquals(float[] fArray, float[] fArray2, float f) {
        for (int i = 0; i < fArray2.length; ++i) {
            FComplexMatrix1DTest.assertEquals((float)fArray[i], (float)fArray2[i], (float)f);
        }
    }
}

