/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.Norm;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.DoubleGivensRotation;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;

public class DoubleGMRES
extends AbstractDoubleIterativeSolver {
    private int restart;
    private DoubleMatrix1D w;
    private DoubleMatrix1D u;
    private DoubleMatrix1D r;
    private DoubleMatrix1D[] v;
    private DoubleMatrix1D s;
    private DoubleMatrix2D H;
    private DoubleGivensRotation[] rotation;

    public DoubleGMRES(DoubleMatrix1D doubleMatrix1D) {
        this(doubleMatrix1D, 30);
    }

    public DoubleGMRES(DoubleMatrix1D doubleMatrix1D, int n) {
        this.w = doubleMatrix1D.copy();
        this.u = doubleMatrix1D.copy();
        this.r = doubleMatrix1D.copy();
        this.setRestart(n);
    }

    public void setRestart(int n) {
        this.restart = n;
        if (n <= 0) {
            throw new IllegalArgumentException("restart must be a positive integer");
        }
        this.s = new DenseDoubleMatrix1D(n + 1);
        this.H = new DenseDoubleMatrix2D(n + 1, n);
        this.rotation = new DoubleGivensRotation[n + 1];
        this.v = new DoubleMatrix1D[n + 1];
        for (int i = 0; i < this.v.length; ++i) {
            this.v[i] = new DenseDoubleMatrix1D((int)this.r.size());
        }
    }

    public DoubleMatrix1D solve(DoubleMatrix2D doubleMatrix2D, DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) throws IterativeSolverDoubleNotConvergedException {
        this.checkSizes(doubleMatrix2D, doubleMatrix1D, doubleMatrix1D2);
        doubleMatrix2D.zMult(doubleMatrix1D2, this.u.assign(doubleMatrix1D), -1.0, 1.0, false);
        this.M.apply(this.u, this.r);
        double d = DenseDoubleAlgebra.DEFAULT.norm(this.r, Norm.Two);
        this.M.apply(doubleMatrix1D, this.u);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, doubleMatrix1D2)) {
            int n;
            int n2;
            this.v[0].assign(this.r, DoubleFunctions.multSecond(1.0 / d));
            this.s.assign(0.0).setQuick(0, d);
            for (n2 = 0; n2 < this.restart && !this.iter.converged(Math.abs(this.s.getQuick(n2))); ++n2) {
                doubleMatrix2D.zMult(this.v[n2], this.u);
                this.M.apply(this.u, this.w);
                for (n = 0; n <= n2; ++n) {
                    this.H.setQuick(n, n2, this.w.zDotProduct(this.v[n]));
                    this.w.assign(this.v[n], DoubleFunctions.plusMultSecond(-this.H.getQuick(n, n2)));
                }
                this.H.setQuick(n2 + 1, n2, DenseDoubleAlgebra.DEFAULT.norm(this.w, Norm.Two));
                this.v[n2 + 1].assign(this.w, DoubleFunctions.multSecond(1.0 / this.H.getQuick(n2 + 1, n2)));
                for (n = 0; n < n2; ++n) {
                    this.rotation[n].apply(this.H, n2, n, n + 1);
                }
                this.rotation[n2] = new DoubleGivensRotation(this.H.getQuick(n2, n2), this.H.getQuick(n2 + 1, n2));
                this.rotation[n2].apply(this.H, n2, n2, n2 + 1);
                this.rotation[n2].apply(this.s, n2, n2 + 1);
                this.iter.next();
            }
            this.s = DenseDoubleAlgebra.DEFAULT.backwardSolve(this.H.viewPart(0, 0, n2, n2), this.s);
            for (n = 0; n < n2; ++n) {
                doubleMatrix1D2.assign(this.v[n], DoubleFunctions.plusMultSecond(this.s.getQuick(n)));
            }
            doubleMatrix2D.zMult(doubleMatrix1D2, this.u.assign(doubleMatrix1D), -1.0, 1.0, false);
            this.M.apply(this.u, this.r);
            d = DenseDoubleAlgebra.DEFAULT.norm(this.r, Norm.Two);
            this.iter.next();
        }
        return doubleMatrix1D2;
    }
}

