% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palmindex.R
\name{palmindex}
\alias{palmindex}
\title{Palm Index}
\usage{
palmindex(posabund, negabund, pseudo = 1e-05, nazeros = TRUE)
}
\arguments{
\item{posabund}{Abundance of the bacteria in the IgA positive/high fraction.}

\item{negabund}{Abundance of the bacteria in the IgA negative/low fraction.}

\item{pseudo}{Pseudo count added to the abundance of the IgA negative fraction if the bacteria is not in that fraction. Defaults to 1e-5. Recommend setting to minimum observed abundance in whole dataset.}

\item{nazeros}{Return NA if the pos and neg abundances are both zero. Default is TRUE.}
}
\value{
A numeric value for the Palm index as defined in Palm et al. (2014, \doi{10.1016/j.cell.2014.08.006}).
}
\description{
This function calculates the immunoglobulin A (IgA) Index as defined in Palm et al. (2014, \doi{10.1016/j.cell.2014.08.006}) for a single taxon in a single sample.
}
\examples{
palmindex(posabund=0.1,negabund=0.2,pseudo=0.0002)
}
\keyword{Palm}
\keyword{coating}
\keyword{iga}
\keyword{iga-seq}
\keyword{index}
