% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dag_test_ISS.R
\name{dag_test_ISS}
\alias{dag_test_ISS}
\title{dag_test_ISS}
\usage{
dag_test_ISS(X0, p, alpha)
}
\arguments{
\item{X0}{a numeric matrix giving points corresponding to hypotheses.}

\item{p}{a numeric vector taking values in (0, 1] such that \code{length(p) == nrow(X0)}.}

\item{alpha}{a numeric value in (0, 1] specifying the Type I error rate.}
}
\value{
A boolean vector of the same length as \code{p} with each element being \code{TRUE} if the corresponding hypothesis is rejected and \code{FALSE} otherwise.
}
\description{
Implements the DAG testing procedure given in Algorithm 1 by \insertCite{MRCS2023;textual}{ISS}.
}
\examples{
X0 <- rbind(c(0.5, 0.6), c(0.8, 0.9), c(0.9, 0.8))
p <- c(0.02, 0.025, 0.1)
alpha <- 0.05
dag_test_ISS(X0, p, alpha)

}
\references{
\insertRef{MRCS2023}{ISS}
}
