% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Finalised_coding.R
\name{sol_path_cplm}
\alias{sol_path_cplm}
\title{The solution path for the case of continuous piecewise-linear signals}
\usage{
sol_path_cplm(x, thr_ic = 1.25, points = 3)
}
\arguments{
\item{x}{A numeric vector containing the data in which you would like to find
change-points.}

\item{thr_ic}{A positive real number with default value equal to 1.25. It is
used to define the threshold. The change-points are estimated by thresholding
with threshold equal to \code{sigma * thr_ic * sqrt(2 * log(T))}, where
\code{T} is the length of the data sequence \code{x} and \code{sigma = mad(diff(diff(x)))/6}.
Because, we would like to overestimate the number of the true change-points in \code{x}, it is
suggested to keep \code{thr_ic} smaller than 1.4, which is the default value used as
the threshold constant in the function \code{\link{win_cplm_th}}.}

\item{points}{A positive integer with default value equal to 3. It defines
the distance between two consecutive end- or start-points of the right- or
left-expanding intervals, respectively.}
}
\value{
The solution path for the case of continuous piecewise-linear signals.
}
\description{
This function starts by over-estimating the number of true change-points.
After that, following an approach based on the values of a suitable contrast function,
it sorts the estimated change-points in a way that the estimation, which is
most-likely to be correct appears first, whereas the least likely to be correct,
appears last. The routine is typically not called directly by the user; it is
employed in \code{\link{cplm_ic}}. For more details, see References.
}
\examples{
three.cpt <- c(seq(0, 499, 1), seq(498.5, 249, -0.5), seq(250.5,999,1.5), seq(998,499,-1))
three.cpt.noise <- three.cpt + rnorm(2000)
solution.path <- sol_path_cplm(three.cpt.noise)
}
\references{
Anastasiou, A. and Fryzlewicz, P. (2018). Detecting multiple generalized change-points
by isolating single ones.
}
\author{
Andreas Anastasiou, \email{a.anastasiou@lse.ac.uk}
}
