% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DispField.R
\name{DispField}
\alias{DispField}
\title{Displacement fields based on 2D cross-covariance}
\usage{
DispField(inputrast1, inputrast2, factv1, facth1, restricted = FALSE)
}
\arguments{
\item{inputrast1}{a raster as produced by terra::rast}

\item{inputrast2}{a raster of equivalent dimension to inputrast1 as produced
by terra::rast}

\item{factv1}{an odd integer for the vertical dimension of sub-grids}

\item{facth1}{an odd integer for the horizontal dimension of sub-grids}

\item{restricted}{logical (TRUE or FALSE)}
}
\value{
A data frame is returned with the following column names: rowcent,
colcent, frowmin, frowmax, fcolmin, fcolmax, centx, centy, dispx, and
dispy. The rowcent and colcent column names are the row and column indices
for the center of each sub-grid; frowmin and frowmax are the sub-grid
minimum and maximum row indices; fcolmin and fcolmax are the sub-grid
minimum and maximum column indices; centx and centy are the projected
coordinates of the centre of the subgrid derived from the raster input
files; dispx and dispy are the displacement in the horizontal and vertical
directions in the same units as the projected coordinates of the raster
input files.
}
\description{
Calculates a displacement field based on the cross-covariance of two input
rasters presumably representing spatial population abundance or density at
two different instances of time.
}
\details{
The input rasters are first converted to equivalent matrices. The function
then divides the domain up into sub-grids of size factv1 X facth1, which are
vertical and horizontal sub-grid dimensions.

If restricted is set to FALSE (the default), the function computes
cross-covariance between each sub-grid of the first input raster and the
entirety of the second input raster and then uses the location of maximum
cross-covariance to estimate displacement in the vertical and horizontal
directions from the centre of each sub-grid.

If restricted is set to TRUE, the function uses cross-covariance between each
sub-grid in the first input raster and the equivalent sub-grid in the second
input raster to estimate vertical and horizontal displacement.

Reference coordinates and cell size are extracted from the first input raster
such that the locations from whence displacement is estimated as well as
displacement estimates can be expressed in the units of the projected
coordinates.

The coordinates are assumed to increase vertically and horizontally from the
lower left corner of the two-dimensional domain.

Caution is warranted when defining the sub-grid dimensions because the
function can produce erroneous results when sub-grids are too small.
}
\examples{
(Mat1 <- matrix(rep(c(1:5, 0, 0, 0, 0), 9), nrow = 9, byrow = TRUE))
(Mat2 <- matrix(rep(c(0, 1:5, 0, 0, 0), 9), nrow = 9, byrow = TRUE))

# rasterizing
rast1 <- terra::rast(Mat1)
terra::plot(rast1)
rast2 <- terra::rast(Mat2)
terra::plot(rast2)

(VFdf1 <- DispField(rast1, rast2, factv1 = 9, facth1 = 9))
# The second raster is shifted right by 1 unit relative to the first raster
# dispx = 1
}
\seealso{
\code{\link{DispFieldbb}} for a similar function using a bounding
box to define a focal region, \code{\link{DispFieldST}} for a version
designed to quantify persistent directional movement when the time series
features more than two time instances, \code{\link{DispFieldSTall}} for a
version designed to quantify persistent directional movement when velocity
is variable in space, and \code{\link{Xcov2D}} for demonstration of how
two-dimensional cross-covariance is used to determine displacement (see
examples of Xcov2D function documentation).
}
