% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ica.elm_forecast.R
\name{ica.elm_forecast}
\alias{ica.elm_forecast}
\title{Forecasting from ICA based ELM model}
\usage{
ica.elm_forecast(ica.elm_model, h = 1)
}
\arguments{
\item{ica.elm_model}{A trained ICA based ELM model.}

\item{h}{Number of periods for forecasting. Defaults to one-step
ahead forecast.}
}
\value{
Vector of point forecasts.
}
\description{
Forecasts are generated recursively from a trained Extreme Learning Machine
built using Independent Component Analysis.
}
\examples{
train_set <- head(price, 12*12)
test_set <- tail(price, 12)
ica.model <- ica.elm_train(train_data = train_set, lags = 12)
y_hat <- ica.elm_forecast(ica.elm_model = ica.model, h = length(test_set))
# Evaluation of the forecasts
if(require("forecast")) forecast::accuracy(y_hat, test_set)
}
\seealso{
\code{\link[=ica.elm_train]{ica.elm_train()}} for training an ICA based ELM model.
}
