% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{icd_meta_blocks}
\alias{icd_meta_blocks}
\title{data.frame containing metadata for the ICD-10-GM code blocks}
\format{
An object of class \code{data.frame} with 4813 rows and 6 columns.
}
\source{
The source data was downloaded from the official download centre
of the German Institute for Medical Documentation and Information (DIMDI).
See also \url{https://www.dimdi.de/dynamic/en/classifications/icd/icd-10-gm/tabular-list/structure/}
}
\usage{
icd_meta_blocks
}
\description{
The ICD blocks (German: "Gruppen") constitute a level in the hierarchy
between the chapters and the three-digit codes. The three-digit code are
grouped in sequence to form 240 groups that represent similar aetiological
diagnoses. Unlike some other grouper systems, the ICD blocks do not consider
similar diagnoses from different chapters of the ICD classification, for
example chronic pain coded as a unspecific symptom (R52.1) and as a
somatoform disorder (F45.4).
}
\details{
\describe{
\item{year}{Year of validity (from 2004)}
\item{icd_block_first}{First three-digit ICD code in the block}
\item{icd_block_last}{Last three-digit ICD code in the block}
\item{chapter}{ICD-10 chapter to which the block belongs}
\item{block_label}{Label for the block}
\item{block_id}{Short label for the block in format "A00-A09"}
}
}
\seealso{
Other ICD-10-GM metadata: 
\code{\link{icd_meta_chapters}},
\code{\link{icd_meta_codes}},
\code{\link{icd_meta_transition}}
}
\concept{ICD-10-GM metadata}
\keyword{datasets}
