% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preproc_fill_daily.R
\name{preproc_fill_daily}
\alias{preproc_fill_daily}
\title{Fills daily data with missing dates as \code{NA} values}
\usage{
preproc_fill_daily(
  data = NULL,
  Date,
  value,
  POR_start = NA,
  POR_end = NA,
  date_format = "\%Y-\%m-\%d"
)
}
\arguments{
\item{data}{'data.frame'. Optional data.frame input, with columns containing \code{Date} and \code{value}.
Column names are specified as strings in the corresponding parameter. Default is \code{NULL}.}

\item{Date}{'Date' or 'character' vector when \code{data = NULL}, or 'character' string identifying
Date column name when \code{data} is specified. Date associated with each value in \code{value}
parameter.}

\item{value}{'numeric' vector when \code{data = NULL}, or 'character' string identifying values
column name when \code{data} is specified.}

\item{POR_start}{'character' value. Optional period of record start. If not specified, defaults
to \code{min(Date)}.}

\item{POR_end}{'character' value. Optional period of record end. If not specified, defaults to
\code{max(Date)}.}

\item{date_format}{'character' string. Format of Date. Default is \code{"\%Y-\%m-\%d"}.}
}
\value{
A data.frame with \code{Date} and \code{value}, sequenced from \code{POR_start} to \code{POR_end} by 1 day.
}
\description{
Fills daily data with missing dates as \code{NA} values. Days that are
absent from the daily time series are inserted with a corresponding value of \code{NA}.
}
\details{
Can be used prior to \code{\link{preproc_precondition_data}} to fill daily data before computation
of n-day moving averages, or prior to \code{\link{preproc_audit_data}}.
}
\examples{
Dates = c(seq.Date(as.Date("2020-01-01"), as.Date("2020-01-10"), by = "1 day"),
          seq.Date(as.Date("2020-01-20"), as.Date("2020-01-31"), by = "1 day"))
values = c(seq.int(1, 22, 1))
preproc_fill_daily(Date = Dates, value = values)

}
\seealso{
\code{\link{preproc_audit_data}}, \code{\link{preproc_precondition_data}}
}
\keyword{preprocessing-data}
