% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VersionValidation.R
\name{checkVersion}
\alias{checkVersion}
\title{Check IPD-IMGT/HLA Release Version Allele Names}
\usage{
checkVersion(version)
}
\arguments{
\item{version}{A character string identifying the release version (branch) of the ANHIG/IMGTHLA Github repository (e.g. '3.53.0'). The value 'Latest' refers to the most recent release.}
}
\value{
A logical. TRUE indicates that data for 'version' is available to the local HLAtools package. FALSE means that data for 'version' is not available.
}
\description{
Determines if allele name data for a given IPD-IMGT/HLA Release Version is present in the local HLAtools package.
}
\note{
For internal HLAtools use.
}
\examples{
checkVersion(version = "3.25.0")
checkVersion(version = "Latest")

}
