% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlleleTrim.R
\name{multiAlleleTrim}
\alias{multiAlleleTrim}
\title{Trim Multiple HLA Allele Names}
\usage{
multiAlleleTrim(alleles, resolution, version = 3, append = FALSE)
}
\arguments{
\item{alleles}{A vector of HLA allele names from a single nomenclature epoch.}

\item{resolution}{A number identifying the number of fields to which the alleles should be trimmed.}

\item{version}{A number identifying the HLA nomenclature epoch under which the allele was named. Epoch 1 allele names are found in IPD-IMGT/HLA Database releases 1.0.0 to 1.16.0. Epoch 2 allele names are found in IPD-IMGT/HLA Database releases 2.0.0 to 2.28.0. Epoch 3 allele names are found in IPD_IMGT/HLA Database releases 3.0.0 and onward.}

\item{append}{A logical. When append = TRUE, the expression variant suffix of a full-length allele name is appended to a truncated allele name. The default value is FALSE.}
}
\value{
A vector of the trimmed allele name, shortened according to the input parameters.
}
\description{
Trim a vector of allele names to a specified number of fields or digits.
}
\note{
Expression variant suffixes will not be removed from full-length allele names that have fewer than four fields or eight digits.
}
\examples{
alleles <- c("A*02:01:01:02L","DRB1*08:07", "DQB1*04:02:01:16Q")
multiAlleleTrim(alleles,2)
multiAlleleTrim(alleles,2,append = TRUE)

alleles <- c("A*01010102L","DRB1*1613N","HLA-Cw*0322Q")
multiAlleleTrim(alleles,1,2,TRUE)
multiAlleleTrim(alleles,2,2)

}
