% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpav.R
\name{gpav.parallel}
\alias{gpav.parallel}
\title{GPAV over examples -- parallel implementation}
\usage{
gpav.parallel(S, g, W = NULL, ncores = 8)
}
\arguments{
\item{S}{a named flat scores matrix with examples on rows and classes on columns (root node included).}

\item{g}{a graph of class \code{graphNEL}. It represents the hierarchy of the classes.}

\item{W}{vector of weight relative to a single example. If \code{W=NULL} (def.) it is assumed that
\code{W} is a unitary vector of the same length of the columns' number of the matrix \code{S} (root node included).}

\item{ncores}{number of cores to use for parallel execution (\code{def. 8}).
If \code{ncores=0}, the maximum number of cores minus one are used.}
}
\value{
A named matrix with the scores of the classes corrected according to the \code{GPAV} algorithm.
}
\description{
Compute \code{GPAV} across all the examples (parallel implementation).
}
\examples{
data(graph);
data(scores);
if(Sys.info()['sysname']!="Windows"){
   S.gpav <- gpav.parallel(S,W=NULL,g,ncores=2);
}
}
