% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fixed_css.R
\name{get_fixed_css}
\alias{get_fixed_css}
\title{Get Fixed \code{C_ss} Data}
\usage{
get_fixed_css(simulated_css, age, obesity, C_ss)
}
\arguments{
\item{simulated_css}{list of pre-generated \code{C_ss} data, for details see:
\code{vignette("package_data", package = "GeoTox")}.}

\item{age}{list of atomic vectors containing ages.}

\item{obesity}{list of atomic vectors containing obesity status.}

\item{C_ss}{list of matrices containing \code{C_ss} values.}
}
\value{
list of matrices or atomic vectors containing \code{C_ss} values.
}
\description{
Get \code{C_ss} values for use in \link{sensitivity_analysis} and \link{compute_sensitivity}.
}
\examples{
# Define inputs
age <- list(c(25, 35, 55),
            c(15, 60))
obesity <- list(c("Obese", "Normal", "Obese"),
                c("Normal", "Normal"))
C_ss <- sample_Css(simulated_css = geo_tox_data$simulated_css,
                   age = age,
                   obesity = obesity)

# Get fixed C_ss data
get_fixed_css(simulated_css = geo_tox_data$simulated_css,
              age = age,
              obesity = obesity,
              C_ss = C_ss)
}
