#' @export
print.ep <- function(x, ...) {
  cat("\n", x$method, "\n\n", sep = "")
  cat("data: ", x$data.name, "\n", sep = "")
  cat("prob. of non-intersection:", paste(x$statistic, collapse = ", "), "\n")
  cat("Adj p-values:", paste(formatC(x$p.value, 5), collapse = ", "), "\n")
  cat("Cutoff:", x$cutoff, "\n\n")
  invisible(x)
}

#' @export
print.rigdd <- function(x, ...) {
  cat("\n", x$method, "\n\n", sep = "")
  cat("Statistic =", paste(formatC(x$statistic, 5), collapse = ", "), "\n")
  cat("Reject null hypothesis of randomness if the value(s) of any of the test statistic > C.
    Calculate C using thrsd.rigdd() function.", "\n\n")
  invisible(x)
}

#' @export
print.rcagdd <- function(x, ...) {
  cat("\n", x$method, "\n\n", sep = "")
  cat("Statistic =", paste(formatC(x$statistic, 5), collapse = ", "), "\n")
  cat("Reject null hypothesis of randomness if the value(s) of any of the test statistic > C.
    Calculate C using thrsd.rcagdd() function.", "\n\n")
  invisible(x)
}