% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mapper.R
\name{plot_mapper}
\alias{plot_mapper}
\title{Plot mapper}
\usage{
plot_mapper(mapper_object, trans_node_size = TRUE, exp_to_res = 1/2)
}
\arguments{
\item{mapper_object}{A list produced as an output of the \code{one_D_Mapper}
function.}

\item{trans_node_size}{Logical, it indicates whether you want to resize
the size of the nodes. \code{TRUE} default option.}

\item{exp_to_res}{Only necessary if trans_node_size is \code{TRUE}. An
exponent of the form 1/n to which the node sizes must be raised in order
to resize them.}
}
\value{
Plots an interactive network using the \code{visNetwork} function.
}
\description{
This function produces an interactive network plot using
the \code{visNetork} function from the mapper results.
}
\examples{
\donttest{
# Create data object
data_object <- list("full_data" = full_data, "survival_time" = survival_time,
                   "survival_event" = survival_event, "case_tag" = case_tag)
class(data_object) <- "data_object"

#Select gene from data object
gene_selection_object <- gene_selection(data_object, gen_select_type="top_bot",
 percent_gen_select=10)

mapper_object <- mapper(data = gene_selection_object[["genes_disease_component"]],
filter_values = gene_selection_object[["filter_values"]],
num_intervals = 5,
percent_overlap = 40, distance_type = "correlation",
clustering_type = "hierarchical",
linkage_type = "single")
plot_mapper(mapper_object)}
}
