% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_fitGraphicalVAR.R
\name{fitGraphicalVAR}
\alias{fitGraphicalVAR}
\title{fitgraphicalVAR}
\usage{
fitGraphicalVAR(
  data,
  nLambda = 50,
  verbose = TRUE,
  gamma,
  scale = TRUE,
  lambda_beta,
  lambda_kappa,
  regularize_mat_beta,
  regularize_mat_kappa,
  maxit.in = 100,
  maxit.out = 100,
  deleteMissings = TRUE,
  penalize.diagonal = TRUE,
  lambda_min_kappa = 0.05,
  lambda_min_beta = lambda_min_kappa,
  mimic = c("current"),
  variableNames,
  beepvar,
  dayvar,
  idvar,
  lags = 1,
  centerWithin = TRUE,
  likelihood = c("unpenalized", "penalized"),
  outputPath
)
}
\arguments{
\item{data}{A matrix or data frame containing repeated measures (rows) on a set of variables (columns).
Must not contain missing data.}

\item{nLambda}{The number of both lambda parameters to test. Defaults to 50,
which results in 2500 models to evaluate.}

\item{verbose}{Logical, should a progress bar be printed to the console?}

\item{gamma}{The EBIC hyper-parameter. Set to 0 to use regular BIC.}

\item{scale}{Logical, should responses be standardized before estimation?}

\item{lambda_beta}{An optional vector of lambda_beta values to test.
Set lambda_beta = 0 argument and lambda_kappa = 0 for unregularized estimation.}

\item{lambda_kappa}{An optional vector of lambda_kappa values to test.
Set lambda_beta = 0 argument and lambda_kappa = 0 for unregularized estimation.}

\item{regularize_mat_beta}{A logical matrix indicating which elements of the beta matrix should be regularized (experimental).}

\item{regularize_mat_kappa}{A logical matrix indicating which elements of the kappa matrix should be regularized (experimental).}

\item{maxit.in}{Maximum number of iterations in the inner loop (computing beta)}

\item{maxit.out}{Maximum number of iterations in the outer loop}

\item{deleteMissings}{Logical, should missing responses be deleted?}

\item{penalize.diagonal}{Logical, should the diagonal of beta be penalized (i.e., penalize auto-regressions)?}

\item{lambda_min_kappa}{Multiplier of maximal tuning parameter for kappa}

\item{lambda_min_beta}{Multiplier of maximal tuning parameter for beta}

\item{mimic}{Allows one to mimic earlier versions of 'graphicalVAR'}

\item{variableNames}{The vector containing name of variables to be analyzed}

\item{beepvar}{String indicating assessment beep per day (if missing, is added).
Adding this argument will cause non-consecutive beeps to be treated as missing!}

\item{dayvar}{String indicating assessment day. Adding this argument makes sure that the first measurement of a day is not
regressed on the last measurement of the previous day.
IMPORTANT: only add this if the data has multiple observations per day.}

\item{idvar}{String indicating the subject ID}

\item{lags}{Vector of lags to include}

\item{centerWithin}{logical, should subject data be within-person centered before estimating fixed effects?}

\item{likelihood}{Should likelihood be computed based on penalized contemporaneous matrix or}

\item{outputPath}{The user specified path to the directory where results files should be stored.}
}
\description{
Fits 'graphicalVAR' with defaults used in 'graphicalVAR' package developed by Sacha Epskamp.
See 'graphicalVAR' documentation by Sacha Epskamp for details.
}
\details{
The following results are returned in the gvarFiles directory:
(1) Separate data frames containing the usual individual 'graphicalVAR' results.
These dataframes contain the person-specific results for each individual obtained by fitting 'graphicalVAR'.
They are prefixed RESULTS_GVAR_SUBJECT
The number of data frames returned equals the number of individuals whose models were successfully
fitted from the input data file.
}
