#' @title Spatial datasets of vegetation index changes.
#'
#' @description The "NDVI" dataset contains NDVI change data from 2010 to 2014 in Inner Mongolia, China.
#' It includes NDVI change and potential variables sampled from six spatial grid sizes: 5 km, 10 km,
#' 20 km, 30 km, 40 km, and 50 km. References for more details and data sources will be provided.
#'
#' @name NDVI
#' @format
#' \describe{
#'   \item{\code{ndvi_5}}{A data frame with 46,295 rows and 7 variables (5 km grid size).}
#'   \item{\code{ndvi_10}}{A data frame with 11,567 rows and 7 variables (10 km grid size).}
#'   \item{\code{ndvi_20}}{A data frame with 2,892 rows and 7 variables (20 km grid size).}
#'   \item{\code{ndvi_30}}{A data frame with 1,290 rows and 7 variables (30 km grid size).}
#'   \item{\code{ndvi_40}}{A data frame with 713 rows and 7 variables (40 km grid size).}
#'   \item{\code{ndvi_50}}{A data frame with 469 rows and 7 variables (50 km grid size).}
#' }
#' @docType data
#' @keywords dataset NDVI
"ndvi_5"

#' @rdname NDVI
#' @format NULL
"ndvi_10"

#' @rdname NDVI
#' @format NULL
"ndvi_20"

#' @rdname NDVI
#' @format NULL
"ndvi_30"

#' @rdname NDVI
#' @format NULL
"ndvi_40"

#' @rdname NDVI
#' @format NULL
"ndvi_50"


#' @title Spatial datasets of H1N1 flu incidences
#'
#' @description The "H1N1" dataset provides provincial statistical incidences of
#' influenza A virus subtype H1N1 in China for 2013. It includes H1N1 incidences and related variables across
#' three different spatial grid sizes: 50 km, 100 km, and 150 km.
#' Detailed references and data sources will be added.
#'
#' @name H1N1
#' @format
#' \describe{
#'   \item{\code{h1n1_50}}{A data frame with 3977 rows and 11 variables (50 km grid size).}
#'   \item{\code{h1n1_100}}{A data frame with 987 rows and 11 variables (100 km grid size).}
#'   \item{\code{h1n1_150}}{A data frame with 443 rows and 11 variables (150 km grid size).}
#' }
#' @docType data
#' @keywords dataset H1N1
"h1n1_50"

#' @rdname H1N1
#' @format NULL
"h1n1_100"

#' @rdname H1N1
#' @format NULL
"h1n1_150"

