% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Domains.R
\name{Domains}
\alias{Domains}
\title{Domains}
\usage{
Domains (y, domains, value)
}
\arguments{
\item{y}{A numeric main vector of size n}

\item{domains}{A numeric/character/logic auxiliary vector of size n}

\item{value}{A value of the auxiliary vector}
}
\value{
A numeric vector, copy of \code{y}, with some values turned zero depending on values of \code{domains} and \code{value}
}
\description{
Given a main vector, an auxiliary one and a value of the latter, identifies positions of the auxiliary vector corresponding
 to values other than the given one. Then, turns zero values of the main vector corresponding to these positions.
}
\examples{
##########   Example 1   ##########
U <- c(13, 18, 20, 14, 9)
#Let build an auxiliary vector indicating whether values in U are above or below the mean.
aux <- c("Below", "Above", "Above", "Below", "Below")
#Now, only values below the mean remain, the other ones are turned zero.
Domains (U, aux, "Below")

##########   Example 2   ##########
data(DatA)
attach(DatA)
#Let calculate total feeding expenses corresponding to households in domain a.
sum (Domains (Feed, Domain, "a"))
}

