% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code.R
\name{ExtractByPoly}
\alias{ExtractByPoly}
\title{Add a Polygon shapefile and raster image.}
\usage{
ExtractByPoly(img, poly.shp, In.colName, Out.colName)
}
\arguments{
\item{img}{Raster image}

\item{poly.shp}{Polygon shapefile with class info}

\item{In.colName}{Name of the column contain polygon id's}

\item{Out.colName}{Name of the output column contain polygon id's}
}
\description{
Add a Polygon shapefile and raster image.
}
\examples{
library(raster)
library(ExtractTrainData)
img<-brick(system.file("extdata","ras.tif",package = "ExtractTrainData"))
poly.shp<-shapefile(system.file("extdata","poly_shp.shp",package = "ExtractTrainData"))
Out.colName<-In.colName<-"Id"

ExtractByPoly(img,poly.shp,In.colName,Out.colName)
}
\author{
Subhadip Datta
}
