% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxTest_supportingFunctions.R
\name{maxTestBoot_func}
\alias{maxTestBoot_func}
\title{An internal function of the EquiTrends Maximum Equivalence Testing procedure using the Bootstrap approaches.}
\usage{
maxTestBoot_func(
  data,
  equiv_threshold,
  alpha,
  n,
  B,
  no_periods,
  base_period,
  type,
  original_names,
  is_panel_balanced
)
}
\arguments{
\item{data}{The data.frame object containing the data for the test. Should be of the form what is returned by the \link[EquiTrends]{EquiTrends_dataconstr} function.}

\item{equiv_threshold}{The equivalence threshold for the test.}

\item{alpha}{The significance level for the test.}

\item{n}{The number of cross-sectional individuals in the data.}

\item{B}{The number of bootstrap replications.}

\item{no_periods}{The number of periods in the data.}

\item{base_period}{The base period for the test. Must be one of the unique periods in the data.}

\item{type}{The type of bootstrap to be used. Must be one of "Boot" or "Wild".}

\item{original_names}{The original names of the control variables in the data.}

\item{is_panel_balanced}{A logical value indicating whether the panel data is balanced.}
}
\value{
an object of class "maxEquivTestBoot"  with
 \item{\code{placebo_coefficients}}{A numeric vector of the estimated placebo coefficients,}
 \item{\code{abs_placebo_coefficients}}{a numeric vector with the absolute values of estimated placebo coefficients,}
 \item{\code{max_abs_coefficient}}{the maximum absolute estimated placebo coefficient,}
 \item{\code{bootstrap_critica_value}}{the by bootstrap found critical value for the equivalence test based on the maximum absolute placebo coefficient,}
 \item{\code{reject_null_hypothesis}}{a logical value indicating whether the null hypothesis of negligible pre-trend differences can be rejected at the specified significance level \code{alpha},}
 \item{\code{B}}{the number of bootstrap samples used to find the critical value,}
 \item{\code{significance_level}}{the chosen significance level of the test \code{alpha},}
 \item{\code{num_individuals}}{the number of cross-sectional individuals (n),}
 \item{\code{num_periods}}{the number of periods (T),}
 \item{\code{num_observations}}{the total number of observations (N),}
 \item{\code{base_period}}{the base period in the data,}
 \item{\code{placebo_names}}{the names corresponding to the placebo coefficients,}
 \item{\code{equiv_threshold_specified}}{a logical value indicating whether an equivalence threshold was specified.}
 \item{\code{is_panel_balanced}}{a logical value indicating whether the panel data is balanced.}
}
\description{
This is a supporting function of the \code{maxEquivTest} function. It calculates the placebo coefficients and the absolute value of the placebo coefficients. It then calculates the critical value by bootstrap if an equivalence threshold is supplied for the test, according to Dette & Schumann (2024).
}
\references{
Dette, H., & Schumann, M. (2024). "Testing for Equivalence of Pre-Trends in Difference-in-Differences Estimation." \emph{Journal of Business & Economic Statistics}, 1–13. DOI: \doi{10.1080/07350015.2024.2308121}
}
