% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint_km_diff.R
\name{confint_km_diff}
\alias{confint_km_diff}
\title{Lower and upper confidence bounds for the difference of two Kaplan-Meier curves}
\usage{
confint_km_diff(alpha, t0, data_r, data_t, plot = TRUE)
}
\arguments{
\item{alpha}{confidence level}

\item{t0}{time point of interest}

\item{data_r, data_t}{datasets containing time and status for each individual}

\item{plot}{if TRUE, a plot of the two Kaplan Meier curves will be given}
}
\value{
A list containing the difference \eqn{S_1(t_0)-S_2(t_0)} and the lower and upper (1-\eqn{\alpha})-confidence bounds. Further a plot of the curves is given.
}
\description{
Function fitting Kaplan-Meier curves \eqn{S_1}, \eqn{S_2} to two groups and yielding
lower and upper (1-\eqn{\alpha})-confidence bounds for the difference \eqn{S_1-S_2} of these
two curves at a specific time point by using Greenwood's formula.
}
\examples{
data(veteran)
veteran_r <- veteran[veteran$trt==1,]
veteran_t <- veteran[veteran$trt==2,]
alpha<-0.05
t0<-80
confint_km_diff(alpha=alpha,t0=t0,data_r=veteran_r,data_t=veteran_t)
}
