% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint_diff.R
\name{confint_diff}
\alias{confint_diff}
\title{Lower and upper confidence bounds for the difference of two parametric survival curves}
\usage{
confint_diff(alpha, t0, m1, m2, B = 1000, data_r, data_t, plot = TRUE)
}
\arguments{
\item{alpha}{confidence level}

\item{t0}{time point of interest}

\item{m1, m2}{type of parametric model. Possible model types are "weibull", "exponential", "gaussian", "logistic", "lognormal" and "loglogistic"}

\item{B}{number of bootstrap repetitions. The default is B=1000}

\item{data_r, data_t}{datasets containing time and status for each individual (have to be referenced as this)}

\item{plot}{if TRUE, a plot of the two survival curves will be given}
}
\value{
A list containing the difference \eqn{S_1(t_0)-S_2(t_0)}, the lower and upper (1-\eqn{\alpha})-confidence bounds and a summary of the two model fits. Further a plot of the curves is given.
}
\description{
Function fitting parametric survival curves \eqn{S_1}, \eqn{S_2} to two groups and
yielding lower and upper (1-\eqn{\alpha})-confidence bounds for the difference \eqn{S_1-S_2} of these
two curves at a specific time point, based on approximating the variance via bootstrap.
For the bootstrap exponentially distributed random censoring is assumed and the parameters estimated from the datasets.
\eqn{m_1} and \eqn{m_2} are parametric survival models following a Weibull, exponential, gaussian, logistic, log-normal or log-logistic distribution.
For the generation of the bootstrap data exponentially distributed right-censoring is assumed and the rates estimated from the datasets.
See Moellenhoff and Tresch <arXiv:2009.06699> for details.
}
\examples{
data(veteran)
veteran_r <- veteran[veteran$trt==1,]
veteran_t <- veteran[veteran$trt==2,]
alpha<-0.05
t0<-80
confint_diff(alpha=alpha,t0=t0,m1="weibull",m2="weibull",data_r=veteran_r,data_t=veteran_t)
}
\references{
K.Moellenhoff and A.Tresch: Survival analysis under non-proportional hazards: investigating non-inferiority or equivalence in time-to-event data <arXiv:2009.06699>
}
