% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NW_lrv.R
\name{NW_lrv}
\alias{NW_lrv}
\title{Long-run covariance estimation using Newey-West (Bartlett) weights}
\usage{
NW_lrv(u, nlag = NULL, demean = TRUE)
}
\arguments{
\item{u}{a vector of residual series, for which we recommend to use the recursive residuals from larger model.}

\item{nlag}{Non-negative integer containing the lag length to use. If empty or not included,
nleg = min(floor(1.2*T^(1/3)),T) will be used.}

\item{demean}{Logical true of false (0 or 1) indicating whether the mean should be subtracted when computing.}
}
\value{
K by K vector of Long run variance using Newey-West (Bartlett) weights.
}
\description{
Given a vector of residuals, it generates the Heteroskedastic Long run variance.
}
\examples{
x<- rnorm(15);
#Newey-West covariance with automatic BW selection
lrcov = NW_lrv(x)
#Newey-West covariance with 10 lags
lrcov = NW_lrv(x, 10)
#Newey-West covariance with 10 lags and no demeaning
lrcov = NW_lrv(x, 10, 0)
}
